/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.AbstractServiceFactory;
import org.apereo.cas.authentication.principal.AbstractWebApplicationService;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.SimpleWebApplicationServiceImpl;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.validation.ValidationResponseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebApplicationServiceFactory
extends AbstractServiceFactory<WebApplicationService> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebApplicationServiceFactory.class);

    private static AbstractWebApplicationService determineWebApplicationFormat(HttpServletRequest request, AbstractWebApplicationService webApplicationService) {
        String format = request != null ? request.getParameter("format") : null;
        try {
            if (StringUtils.isNotBlank((CharSequence)format)) {
                ValidationResponseType formatType = ValidationResponseType.valueOf((String)format.toUpperCase());
                webApplicationService.setFormat(formatType);
            }
        }
        catch (Exception e) {
            LOGGER.error("Format specified in the request [{}] is not recognized", (Object)format);
        }
        return webApplicationService;
    }

    protected static AbstractWebApplicationService newWebApplicationService(HttpServletRequest request, String serviceToUse) {
        String artifactId = request != null ? request.getParameter("ticket") : null;
        String id = WebApplicationServiceFactory.cleanupUrl(serviceToUse);
        SimpleWebApplicationServiceImpl newService = new SimpleWebApplicationServiceImpl(id, serviceToUse, artifactId);
        WebApplicationServiceFactory.determineWebApplicationFormat(request, newService);
        return newService;
    }

    protected String getRequestedService(HttpServletRequest request) {
        String targetService = request.getParameter("targetService");
        String service = request.getParameter("service");
        Object serviceAttribute = request.getAttribute("service");
        String serviceToUse = null;
        if (StringUtils.isNotBlank((CharSequence)targetService)) {
            serviceToUse = targetService;
        } else if (StringUtils.isNotBlank((CharSequence)service)) {
            serviceToUse = service;
        } else if (serviceAttribute != null) {
            serviceToUse = serviceAttribute instanceof Service ? ((Service)serviceAttribute).getId() : serviceAttribute.toString();
        }
        if (StringUtils.isBlank((CharSequence)serviceToUse)) {
            return null;
        }
        return serviceToUse;
    }

    public WebApplicationService createService(HttpServletRequest request) {
        String serviceToUse = this.getRequestedService(request);
        if (StringUtils.isBlank((CharSequence)serviceToUse)) {
            LOGGER.debug("No service is specified in the request. Skipping service creation");
            return null;
        }
        return WebApplicationServiceFactory.newWebApplicationService(request, serviceToUse);
    }

    public WebApplicationService createService(String id) {
        return WebApplicationServiceFactory.newWebApplicationService(HttpRequestUtils.getHttpServletRequestFromRequestAttributes(), id);
    }
}

