/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apereo.cas.authentication.principal.ResponseBuilder;
import org.apereo.cas.authentication.principal.ResponseBuilderLocator;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public class DefaultWebApplicationResponseBuilderLocator
implements ResponseBuilderLocator<WebApplicationService> {
    private static final long serialVersionUID = 388417797622191740L;
    private final transient List<ResponseBuilder> builders;

    public DefaultWebApplicationResponseBuilderLocator(ApplicationContext applicationContext) {
        Map beans = applicationContext.getBeansOfType(ResponseBuilder.class, false, true);
        this.builders = beans.values().stream().collect(Collectors.toList());
        AnnotationAwareOrderComparator.sortIfNecessary(this.builders);
    }

    public ResponseBuilder locate(WebApplicationService service) {
        return this.builders.stream().filter(r -> r.supports(service)).findFirst().orElse(null);
    }
}

