/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apereo.cas.authentication.principal.Response;
import org.apereo.cas.util.EncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResponse
implements Response {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultResponse.class);
    private static final Pattern NON_PRINTABLE = Pattern.compile("[\\x00-\\x1F\\x7F]+");
    private static final int CONST_REDIRECT_RESPONSE_MULTIPLIER = 40;
    private static final int CONST_REDIRECT_RESPONSE_BUFFER = 100;
    private static final long serialVersionUID = -8251042088720603062L;
    private final Response.ResponseType responseType;
    private final String url;
    private final Map<String, String> attributes;

    protected DefaultResponse(Response.ResponseType responseType, String url, Map<String, String> attributes) {
        this.responseType = responseType;
        this.url = url;
        this.attributes = attributes;
    }

    public static Response getPostResponse(String url, Map<String, String> attributes) {
        return new DefaultResponse(Response.ResponseType.POST, url, attributes);
    }

    public static Response getHeaderResponse(String url, Map<String, String> attributes) {
        return new DefaultResponse(Response.ResponseType.HEADER, url, attributes);
    }

    public static Response getRedirectResponse(String url, Map<String, String> parameters) {
        StringBuilder builder = new StringBuilder(parameters.size() * 40 + 100);
        String sanitizedUrl = DefaultResponse.sanitizeUrl(url);
        LOGGER.debug("Sanitized URL for redirect response is [{}]", (Object)sanitizedUrl);
        String[] fragmentSplit = sanitizedUrl.split("#");
        builder.append(fragmentSplit[0]);
        String params = parameters.entrySet().stream().filter(entry -> entry.getValue() != null).map(entry -> {
            String param;
            try {
                param = String.join((CharSequence)"=", (CharSequence)entry.getKey(), EncodingUtils.urlEncode((String)((String)entry.getValue())));
            }
            catch (Exception e) {
                param = String.join((CharSequence)"=", (CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
            return param;
        }).collect(Collectors.joining("&"));
        if (params != null && !params.isEmpty()) {
            builder.append(url.contains("?") ? "&" : "?");
            builder.append(params);
        }
        if (fragmentSplit.length > 1) {
            builder.append('#');
            builder.append(fragmentSplit[1]);
        }
        String urlRedirect = builder.toString();
        LOGGER.debug("Final redirect response is [{}]", (Object)urlRedirect);
        return new DefaultResponse(Response.ResponseType.REDIRECT, urlRedirect, parameters);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Response.ResponseType getResponseType() {
        return this.responseType;
    }

    public String getUrl() {
        return this.url;
    }

    private static String sanitizeUrl(String url) {
        Matcher m = NON_PRINTABLE.matcher(url);
        StringBuffer sb = new StringBuffer(url.length());
        boolean hasNonPrintable = false;
        while (m.find()) {
            m.appendReplacement(sb, " ");
            hasNonPrintable = true;
        }
        m.appendTail(sb);
        if (hasNonPrintable) {
            LOGGER.warn("The following redirect URL has been sanitized and may be sign of attack:\n[{}]", (Object)url);
        }
        return sb.toString();
    }
}

