/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apereo.cas.authentication.principal.DefaultResponse;
import org.apereo.cas.authentication.principal.Response;
import org.apereo.cas.authentication.principal.ResponseBuilder;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.util.HttpRequestUtils;

public abstract class AbstractWebApplicationServiceResponseBuilder
implements ResponseBuilder<WebApplicationService> {
    private static final long serialVersionUID = -4584738964007702423L;

    protected Response buildRedirect(WebApplicationService service, Map<String, String> parameters) {
        return DefaultResponse.getRedirectResponse(service.getOriginalUrl(), parameters);
    }

    protected Response buildHeader(WebApplicationService service, Map<String, String> parameters) {
        return DefaultResponse.getHeaderResponse(service.getOriginalUrl(), parameters);
    }

    protected Response buildPost(WebApplicationService service, Map<String, String> parameters) {
        return DefaultResponse.getPostResponse(service.getOriginalUrl(), parameters);
    }

    protected Response.ResponseType getWebApplicationServiceResponseType() {
        String method;
        HttpServletRequest request = HttpRequestUtils.getHttpServletRequestFromRequestAttributes();
        String string = method = request != null ? request.getParameter("method") : null;
        if (StringUtils.isBlank((CharSequence)method)) {
            return Response.ResponseType.REDIRECT;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)Response.ResponseType.HEADER.name())) {
            return Response.ResponseType.HEADER;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)Response.ResponseType.POST.name())) {
            return Response.ResponseType.POST;
        }
        return Response.ResponseType.REDIRECT;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return new EqualsBuilder().isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().toHashCode();
    }

    public int getOrder() {
        return 0;
    }
}

