/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.validation.ValidationResponseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Inheritance
@DiscriminatorColumn(name="service_type", length=50, discriminatorType=DiscriminatorType.STRING, columnDefinition="VARCHAR(50) DEFAULT 'simple'")
@Table(name="WebApplicationServices")
public abstract class AbstractWebApplicationService
implements WebApplicationService {
    private static final long serialVersionUID = 610105280927740076L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractWebApplicationService.class);
    @Id
    @JsonProperty
    private String id;
    @JsonProperty
    @Column(length=255, updatable=true, insertable=true, nullable=false)
    private String originalUrl;
    @Column(length=255, updatable=true, insertable=true, nullable=true)
    private String artifactId;
    @JsonProperty
    private String principal;
    @Column(updatable=true, insertable=true, nullable=false)
    private boolean loggedOutAlready;
    @Column(updatable=true, insertable=true, nullable=false)
    private ValidationResponseType format = ValidationResponseType.XML;

    protected AbstractWebApplicationService() {
    }

    protected AbstractWebApplicationService(String id, String originalUrl, String artifactId) {
        this.id = id;
        this.originalUrl = originalUrl;
        this.artifactId = artifactId;
    }

    public String getId() {
        return this.id;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @JsonIgnore
    public Map<String, Object> getAttributes() {
        return new HashMap<String, Object>(0);
    }

    public String getOriginalUrl() {
        return this.originalUrl;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public boolean isLoggedOutAlready() {
        return this.loggedOutAlready;
    }

    public void setLoggedOutAlready(boolean loggedOutAlready) {
        this.loggedOutAlready = loggedOutAlready;
    }

    @JsonIgnore
    public ValidationResponseType getFormat() {
        return this.format;
    }

    public void setFormat(ValidationResponseType format) {
        this.format = format;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractWebApplicationService rhs = (AbstractWebApplicationService)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.id, (Object)rhs.id).append((Object)this.originalUrl, (Object)rhs.originalUrl).append((Object)this.artifactId, (Object)rhs.artifactId).append((Object)this.principal, (Object)rhs.principal).append(this.loggedOutAlready, rhs.loggedOutAlready).append((Object)this.format, (Object)rhs.format);
        return builder.isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.originalUrl).append((Object)this.artifactId).append((Object)this.principal).append(this.loggedOutAlready).append((Object)this.format).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("originalUrl", (Object)this.originalUrl).append("artifactId", (Object)this.artifactId).append("principal", (Object)this.principal).append("loggedOutAlready", this.loggedOutAlready).append("format", (Object)this.format).toString();
    }
}

