/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.authentication.MultifactorTriggerSelectionStrategy;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceMultifactorPolicy;
import org.apereo.cas.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DefaultMultifactorTriggerSelectionStrategy
implements MultifactorTriggerSelectionStrategy {
    private static final Splitter ATTR_NAMES = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private final String requestParameter;
    private final String globalPrincipalAttributeNameTriggers;

    public DefaultMultifactorTriggerSelectionStrategy(String attributeNameTriggers, String requestParameter) {
        this.globalPrincipalAttributeNameTriggers = attributeNameTriggers;
        this.requestParameter = requestParameter;
    }

    public Optional<String> resolve(Collection<MultifactorAuthenticationProvider> providers, HttpServletRequest request, RegisteredService service, Principal principal) {
        RegisteredServiceMultifactorPolicy policy;
        Optional<String> provider = Optional.empty();
        if (providers == null || providers.isEmpty()) {
            return provider;
        }
        Set validProviderIds = providers.stream().map(MultifactorAuthenticationProvider::getId).collect(Collectors.toSet());
        if (request != null) {
            provider = Optional.ofNullable(request.getParameter(this.requestParameter)).filter(validProviderIds::contains);
        }
        if (!provider.isPresent() && service != null && DefaultMultifactorTriggerSelectionStrategy.shouldApplyRegisteredServiceMultifactorPolicy(policy = service.getMultifactorPolicy(), principal)) {
            provider = policy.getMultifactorAuthenticationProviders().stream().filter(validProviderIds::contains).findFirst();
        }
        if (!provider.isPresent() && principal != null && StringUtils.hasText((String)this.globalPrincipalAttributeNameTriggers)) {
            provider = StreamSupport.stream(ATTR_NAMES.split((CharSequence)this.globalPrincipalAttributeNameTriggers).spliterator(), false).map(principal.getAttributes()::get).filter(Objects::nonNull).map(CollectionUtils::toCollection).flatMap(Collection::stream).filter(String.class::isInstance).map(String.class::cast).filter(validProviderIds::contains).findFirst();
        }
        return provider;
    }

    private static boolean shouldApplyRegisteredServiceMultifactorPolicy(RegisteredServiceMultifactorPolicy policy, Principal principal) {
        String attrName = policy.getPrincipalAttributeNameTrigger();
        String attrValue = policy.getPrincipalAttributeValueToMatch();
        if (!StringUtils.hasText((String)attrName) || !StringUtils.hasText((String)attrValue)) {
            return true;
        }
        if (principal == null) {
            return true;
        }
        Predicate<String> attrValuePredicate = Pattern.compile(attrValue).asPredicate();
        return StreamSupport.stream(ATTR_NAMES.split((CharSequence)attrName).spliterator(), false).map(principal.getAttributes()::get).filter(Objects::nonNull).map(CollectionUtils::toCollection).flatMap(Collection::stream).filter(String.class::isInstance).map(String.class::cast).anyMatch(attrValuePredicate);
    }
}

