/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import lombok.Generated;
import org.apereo.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.apereo.cas.util.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeBasedRegisteredServiceAccessStrategy
extends DefaultRegisteredServiceAccessStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeBasedRegisteredServiceAccessStrategy.class);
    private static final long serialVersionUID = -6180748828025837047L;
    private String startingDateTime;
    private String endingDateTime;

    public TimeBasedRegisteredServiceAccessStrategy(boolean enabled, boolean ssoEnabled) {
        super(enabled, ssoEnabled);
    }

    @Override
    public boolean isServiceAccessAllowed() {
        if (!this.doesStartingTimeAllowServiceAccess()) {
            return false;
        }
        if (!this.doesEndingTimeAllowServiceAccess()) {
            return false;
        }
        return super.isServiceAccessAllowed();
    }

    protected boolean doesEndingTimeAllowServiceAccess() {
        if (this.endingDateTime != null) {
            ZonedDateTime et = DateTimeUtils.zonedDateTimeOf((String)this.endingDateTime);
            if (et != null) {
                if (ZonedDateTime.now().isAfter(et)) {
                    LOGGER.warn("Service access not allowed because it ended at [{}]. Now is [{}]", (Object)this.endingDateTime, (Object)ZonedDateTime.now());
                    return false;
                }
            } else {
                LocalDateTime etLocal = DateTimeUtils.localDateTimeOf((String)this.endingDateTime);
                if (etLocal != null && LocalDateTime.now().isAfter(etLocal)) {
                    LOGGER.warn("Service access not allowed because it ended at [{}]. Now is [{}]", (Object)this.endingDateTime, (Object)LocalDateTime.now());
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean doesStartingTimeAllowServiceAccess() {
        if (this.startingDateTime != null) {
            ZonedDateTime st = DateTimeUtils.zonedDateTimeOf((String)this.startingDateTime);
            if (st != null) {
                if (ZonedDateTime.now().isBefore(st)) {
                    LOGGER.warn("Service access not allowed because it starts at [{}]. Zoned now is [{}]", (Object)this.startingDateTime, (Object)ZonedDateTime.now());
                    return false;
                }
            } else {
                LocalDateTime stLocal = DateTimeUtils.localDateTimeOf((String)this.startingDateTime);
                if (stLocal != null && LocalDateTime.now().isBefore(stLocal)) {
                    LOGGER.warn("Service access not allowed because it starts at [{}]. Local now is [{}]", (Object)this.startingDateTime, (Object)ZonedDateTime.now());
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated
    public String toString() {
        return "TimeBasedRegisteredServiceAccessStrategy(super=" + super.toString() + ", startingDateTime=" + this.startingDateTime + ", endingDateTime=" + this.endingDateTime + ")";
    }

    @Generated
    public String getStartingDateTime() {
        return this.startingDateTime;
    }

    @Generated
    public String getEndingDateTime() {
        return this.endingDateTime;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeBasedRegisteredServiceAccessStrategy)) {
            return false;
        }
        TimeBasedRegisteredServiceAccessStrategy other = (TimeBasedRegisteredServiceAccessStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$startingDateTime = this.startingDateTime;
        String other$startingDateTime = other.startingDateTime;
        if (this$startingDateTime == null ? other$startingDateTime != null : !this$startingDateTime.equals(other$startingDateTime)) {
            return false;
        }
        String this$endingDateTime = this.endingDateTime;
        String other$endingDateTime = other.endingDateTime;
        return !(this$endingDateTime == null ? other$endingDateTime != null : !this$endingDateTime.equals(other$endingDateTime));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimeBasedRegisteredServiceAccessStrategy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $startingDateTime = this.startingDateTime;
        result = result * 59 + ($startingDateTime == null ? 43 : $startingDateTime.hashCode());
        String $endingDateTime = this.endingDateTime;
        result = result * 59 + ($endingDateTime == null ? 43 : $endingDateTime.hashCode());
        return result;
    }

    @Generated
    public void setStartingDateTime(String startingDateTime) {
        this.startingDateTime = startingDateTime;
    }

    @Generated
    public void setEndingDateTime(String endingDateTime) {
        this.endingDateTime = endingDateTime;
    }

    @Generated
    public TimeBasedRegisteredServiceAccessStrategy() {
    }
}

