/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.email.EmailProperties;
import org.apereo.cas.configuration.model.support.sms.SmsProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.events.service.CasRegisteredServiceExpiredEvent;
import org.apereo.cas.support.events.service.CasRegisteredServicesRefreshEvent;
import org.apereo.cas.util.io.CommunicationsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;

public class RegisteredServicesEventListener {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServicesEventListener.class);
    private final ServicesManager servicesManager;
    private final CasConfigurationProperties casProperties;
    private final CommunicationsManager communicationsManager;

    @EventListener
    public void handleRefreshEvent(CasRegisteredServicesRefreshEvent event) {
        this.servicesManager.load();
    }

    @EventListener
    public void handleRegisteredServiceExpiredEvent(CasRegisteredServiceExpiredEvent event) {
        String message;
        RegisteredService registeredService = event.getRegisteredService();
        List contacts = registeredService.getContacts();
        EmailProperties mail = this.casProperties.getServiceRegistry().getMail();
        SmsProperties sms = this.casProperties.getServiceRegistry().getSms();
        String serviceName = (String)StringUtils.defaultIfBlank((CharSequence)registeredService.getName(), (CharSequence)registeredService.getServiceId());
        if (this.communicationsManager.isMailSenderDefined()) {
            message = String.format(mail.getText(), serviceName);
            contacts.stream().filter(c -> StringUtils.isNotBlank((CharSequence)c.getEmail())).forEach(c -> this.communicationsManager.email(message, mail.getFrom(), mail.getSubject(), c.getEmail(), mail.getCc(), mail.getBcc()));
        }
        if (this.communicationsManager.isSmsSenderDefined()) {
            message = String.format(sms.getText(), serviceName);
            contacts.stream().filter(c -> StringUtils.isNotBlank((CharSequence)c.getPhone())).forEach(c -> this.communicationsManager.sms(sms.getFrom(), c.getPhone(), message));
        }
        this.servicesManager.load();
    }

    @Generated
    public RegisteredServicesEventListener(ServicesManager servicesManager, CasConfigurationProperties casProperties, CommunicationsManager communicationsManager) {
        this.servicesManager = servicesManager;
        this.casProperties = casProperties;
        this.communicationsManager = communicationsManager;
    }
}

