/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.regex.Pattern;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.AbstractRegisteredService;
import org.apereo.cas.util.RegexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DiscriminatorValue(value="regex")
public class RegexRegisteredService
extends AbstractRegisteredService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegexRegisteredService.class);
    private static final long serialVersionUID = -8258660210826975771L;
    private transient Pattern servicePattern;

    @Override
    public void setServiceId(String id) {
        this.serviceId = id;
        this.servicePattern = null;
    }

    public boolean matches(Service service) {
        return service != null && this.matches(service.getId());
    }

    public boolean matches(String serviceId) {
        if (this.servicePattern == null) {
            this.servicePattern = RegexUtils.createPattern((String)this.serviceId);
        }
        return StringUtils.isBlank((CharSequence)serviceId) ? false : this.servicePattern.matcher(serviceId).matches();
    }

    @Override
    protected AbstractRegisteredService newInstance() {
        return new RegexRegisteredService();
    }

    @JsonIgnore
    public String getFriendlyName() {
        return "CAS Client";
    }
}

