/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Matcher;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.BaseRegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.ScriptingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;

public class GroovyRegisteredServiceUsernameProvider
extends BaseRegisteredServiceUsernameAttributeProvider {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyRegisteredServiceUsernameProvider.class);
    private static final long serialVersionUID = 5823989148794052951L;
    private String groovyScript;

    @Override
    public String resolveUsernameInternal(Principal principal, Service service, RegisteredService registeredService) {
        Matcher matcherInline = ScriptingUtils.getMatcherForInlineGroovyScript((String)this.groovyScript);
        Matcher matcherFile = ScriptingUtils.getMatcherForExternalGroovyScript((String)this.groovyScript);
        if (matcherInline.find()) {
            return this.resolveUsernameFromInlineGroovyScript(principal, service, matcherInline.group(1));
        }
        if (matcherFile.find()) {
            return this.resolveUsernameFromExternalGroovyScript(principal, service, matcherFile.group(1));
        }
        LOGGER.warn("Groovy script [{}] is not valid. CAS will switch to use the default principal identifier [{}]", (Object)this.groovyScript, (Object)principal.getId());
        return principal.getId();
    }

    private String resolveUsernameFromExternalGroovyScript(Principal principal, Service service, String scriptFile) {
        try {
            LOGGER.debug("Found groovy script to execute");
            AbstractResource resourceFrom = ResourceUtils.getResourceFrom((String)scriptFile);
            String script = IOUtils.toString((InputStream)resourceFrom.getInputStream(), (Charset)StandardCharsets.UTF_8);
            Object result = GroovyRegisteredServiceUsernameProvider.getGroovyAttributeValue(principal, script);
            if (result != null) {
                LOGGER.debug("Found username [{}] from script [{}]", result, (Object)scriptFile);
                return result.toString();
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        LOGGER.warn("Groovy script [{}] returned no value for username attribute. Fallback to default [{}]", (Object)this.groovyScript, (Object)principal.getId());
        return principal.getId();
    }

    private String resolveUsernameFromInlineGroovyScript(Principal principal, Service service, String script) {
        try {
            LOGGER.debug("Found groovy script to execute [{}]", (Object)this.groovyScript);
            Object result = GroovyRegisteredServiceUsernameProvider.getGroovyAttributeValue(principal, script);
            if (result != null) {
                LOGGER.debug("Found username [{}] from script [{}]", result, (Object)this.groovyScript);
                return result.toString();
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        LOGGER.warn("Groovy script [{}] returned no value for username attribute. Fallback to default [{}]", (Object)this.groovyScript, (Object)principal.getId());
        return principal.getId();
    }

    private static Object getGroovyAttributeValue(Principal principal, String script) {
        Map args = CollectionUtils.wrap((String)"attributes", (Object)principal.getAttributes(), (String)"id", (Object)principal.getId(), (String)"logger", (Object)LOGGER);
        return ScriptingUtils.executeGroovyShellScript((String)script, (Map)args, Object.class);
    }

    @Generated
    public String getGroovyScript() {
        return this.groovyScript;
    }

    @Generated
    public void setGroovyScript(String groovyScript) {
        this.groovyScript = groovyScript;
    }

    @Generated
    public GroovyRegisteredServiceUsernameProvider() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroovyRegisteredServiceUsernameProvider)) {
            return false;
        }
        GroovyRegisteredServiceUsernameProvider other = (GroovyRegisteredServiceUsernameProvider)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groovyScript = this.groovyScript;
        String other$groovyScript = other.groovyScript;
        return !(this$groovyScript == null ? other$groovyScript != null : !this$groovyScript.equals(other$groovyScript));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GroovyRegisteredServiceUsernameProvider;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groovyScript = this.groovyScript;
        result = result * 59 + ($groovyScript == null ? 43 : $groovyScript.hashCode());
        return result;
    }

    @Generated
    public GroovyRegisteredServiceUsernameProvider(String groovyScript) {
        this.groovyScript = groovyScript;
    }
}

