/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.persistence.PostLoad;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apereo.cas.services.DefaultRegisteredServiceDelegatedAuthenticationPolicy;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceDelegatedAuthenticationPolicy;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.RegexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRegisteredServiceAccessStrategy
implements RegisteredServiceAccessStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRegisteredServiceAccessStrategy.class);
    private static final long serialVersionUID = 1245279151345635245L;
    protected int order;
    protected boolean enabled = true;
    protected boolean ssoEnabled = true;
    protected URI unauthorizedRedirectUrl;
    protected RegisteredServiceDelegatedAuthenticationPolicy delegatedAuthenticationPolicy = new DefaultRegisteredServiceDelegatedAuthenticationPolicy();
    protected boolean requireAllAttributes = true;
    protected Map<String, Set<String>> requiredAttributes = new HashMap<String, Set<String>>();
    protected Map<String, Set<String>> rejectedAttributes = new HashMap<String, Set<String>>();
    protected boolean caseInsensitive;

    public DefaultRegisteredServiceAccessStrategy() {
        this(true, true);
    }

    public DefaultRegisteredServiceAccessStrategy(boolean enabled, boolean ssoEnabled) {
        this.enabled = enabled;
        this.ssoEnabled = ssoEnabled;
    }

    public DefaultRegisteredServiceAccessStrategy(Map<String, Set<String>> requiredAttributes, Map<String, Set<String>> rejectedAttributes) {
        this();
        this.requiredAttributes = requiredAttributes;
        this.rejectedAttributes = rejectedAttributes;
    }

    public DefaultRegisteredServiceAccessStrategy(Map<String, Set<String>> requiredAttributes) {
        this();
        this.requiredAttributes = requiredAttributes;
    }

    @PostLoad
    public void postLoad() {
        this.delegatedAuthenticationPolicy = (RegisteredServiceDelegatedAuthenticationPolicy)ObjectUtils.defaultIfNull((Object)this.delegatedAuthenticationPolicy, (Object)new DefaultRegisteredServiceDelegatedAuthenticationPolicy());
    }

    public Map<String, Set<String>> getRequiredAttributes() {
        return this.requiredAttributes;
    }

    @JsonIgnore
    public boolean isServiceAccessAllowedForSso() {
        if (!this.ssoEnabled) {
            LOGGER.trace("Service is not authorized to participate in SSO.");
            return false;
        }
        return true;
    }

    @JsonIgnore
    public boolean isServiceAccessAllowed() {
        if (!this.enabled) {
            LOGGER.trace("Service is not enabled in service registry.");
            return false;
        }
        return true;
    }

    @JsonIgnore
    public void setServiceAccessAllowed(boolean value) {
        this.enabled = value;
    }

    public boolean doPrincipalAttributesAllowServiceAccess(String principal, Map<String, Object> principalAttributes) {
        if (this.rejectedAttributes.isEmpty() && this.requiredAttributes.isEmpty()) {
            LOGGER.debug("Skipping access strategy policy, since no attributes rules are defined");
            return true;
        }
        if (!this.enoughAttributesAvailableToProcess(principal, principalAttributes)) {
            LOGGER.debug("Access is denied. There are not enough attributes available to satisfy requirements");
            return false;
        }
        if (this.doRejectedAttributesRefusePrincipalAccess(principalAttributes)) {
            LOGGER.debug("Access is denied. The principal carries attributes that would reject service access");
            return false;
        }
        if (!this.doRequiredAttributesAllowPrincipalAccess(principalAttributes, this.requiredAttributes)) {
            LOGGER.debug("Access is denied. The principal does not have the required attributes [{}] specified by this strategy", this.requiredAttributes);
            return false;
        }
        return true;
    }

    protected boolean doRequiredAttributesAllowPrincipalAccess(Map<String, Object> principalAttributes, Map<String, Set<String>> requiredAttributes) {
        LOGGER.debug("These required attributes [{}] are examined against [{}] before service can proceed.", requiredAttributes, principalAttributes);
        if (requiredAttributes.isEmpty()) {
            return true;
        }
        return this.requiredAttributesFoundInMap(principalAttributes, requiredAttributes);
    }

    protected boolean doRejectedAttributesRefusePrincipalAccess(Map<String, Object> principalAttributes) {
        LOGGER.debug("These rejected attributes [{}] are examined against [{}] before service can proceed.", this.rejectedAttributes, principalAttributes);
        if (this.rejectedAttributes.isEmpty()) {
            return false;
        }
        return this.requiredAttributesFoundInMap(principalAttributes, this.rejectedAttributes);
    }

    protected boolean enoughAttributesAvailableToProcess(String principal, Map<String, Object> principalAttributes) {
        if (!this.enoughRequiredAttributesAvailableToProcess(principalAttributes, this.requiredAttributes)) {
            return false;
        }
        if (principalAttributes.size() < this.rejectedAttributes.size()) {
            LOGGER.debug("The size of the principal attributes that are [{}] does not match defined rejected attributes, which means the principal is not carrying enough data to grant authorization", principalAttributes);
            return false;
        }
        return true;
    }

    protected boolean enoughRequiredAttributesAvailableToProcess(Map<String, Object> principalAttributes, Map<String, Set<String>> requiredAttributes) {
        if (principalAttributes.isEmpty() && !requiredAttributes.isEmpty()) {
            LOGGER.debug("No principal attributes are found to satisfy defined attribute requirements");
            return false;
        }
        if (principalAttributes.size() < requiredAttributes.size()) {
            LOGGER.debug("The size of the principal attributes that are [{}] does not match defined required attributes, which indicates the principal is not carrying enough data to grant authorization", principalAttributes);
            return false;
        }
        return true;
    }

    protected boolean requiredAttributesFoundInMap(Map<String, Object> principalAttributes, Map<String, Set<String>> requiredAttributes) {
        Set difference = requiredAttributes.keySet().stream().filter(a -> principalAttributes.keySet().contains(a)).collect(Collectors.toSet());
        if (this.requireAllAttributes && difference.size() < requiredAttributes.size()) {
            return false;
        }
        return difference.stream().anyMatch(key -> {
            Set values = (Set)requiredAttributes.get(key);
            Set availableValues = CollectionUtils.toCollection(principalAttributes.get(key));
            Pattern pattern = RegexUtils.concatenate((Collection)values, (boolean)this.caseInsensitive);
            if (pattern != RegexUtils.MATCH_NOTHING_PATTERN) {
                return availableValues.stream().map(Object::toString).anyMatch(pattern.asPredicate());
            }
            return availableValues.stream().anyMatch(values::contains);
        });
    }

    @Generated
    public String toString() {
        return "DefaultRegisteredServiceAccessStrategy(order=" + this.order + ", enabled=" + this.enabled + ", ssoEnabled=" + this.ssoEnabled + ", unauthorizedRedirectUrl=" + this.unauthorizedRedirectUrl + ", delegatedAuthenticationPolicy=" + this.delegatedAuthenticationPolicy + ", requireAllAttributes=" + this.requireAllAttributes + ", requiredAttributes=" + this.requiredAttributes + ", rejectedAttributes=" + this.rejectedAttributes + ", caseInsensitive=" + this.caseInsensitive + ")";
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public boolean isSsoEnabled() {
        return this.ssoEnabled;
    }

    @Generated
    public URI getUnauthorizedRedirectUrl() {
        return this.unauthorizedRedirectUrl;
    }

    @Generated
    public RegisteredServiceDelegatedAuthenticationPolicy getDelegatedAuthenticationPolicy() {
        return this.delegatedAuthenticationPolicy;
    }

    @Generated
    public boolean isRequireAllAttributes() {
        return this.requireAllAttributes;
    }

    @Generated
    public Map<String, Set<String>> getRejectedAttributes() {
        return this.rejectedAttributes;
    }

    @Generated
    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultRegisteredServiceAccessStrategy)) {
            return false;
        }
        DefaultRegisteredServiceAccessStrategy other = (DefaultRegisteredServiceAccessStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.order != other.order) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.ssoEnabled != other.ssoEnabled) {
            return false;
        }
        URI this$unauthorizedRedirectUrl = this.unauthorizedRedirectUrl;
        URI other$unauthorizedRedirectUrl = other.unauthorizedRedirectUrl;
        if (this$unauthorizedRedirectUrl == null ? other$unauthorizedRedirectUrl != null : !((Object)this$unauthorizedRedirectUrl).equals(other$unauthorizedRedirectUrl)) {
            return false;
        }
        RegisteredServiceDelegatedAuthenticationPolicy this$delegatedAuthenticationPolicy = this.delegatedAuthenticationPolicy;
        RegisteredServiceDelegatedAuthenticationPolicy other$delegatedAuthenticationPolicy = other.delegatedAuthenticationPolicy;
        if (this$delegatedAuthenticationPolicy == null ? other$delegatedAuthenticationPolicy != null : !this$delegatedAuthenticationPolicy.equals(other$delegatedAuthenticationPolicy)) {
            return false;
        }
        if (this.requireAllAttributes != other.requireAllAttributes) {
            return false;
        }
        Map<String, Set<String>> this$requiredAttributes = this.requiredAttributes;
        Map<String, Set<String>> other$requiredAttributes = other.requiredAttributes;
        if (this$requiredAttributes == null ? other$requiredAttributes != null : !((Object)this$requiredAttributes).equals(other$requiredAttributes)) {
            return false;
        }
        Map<String, Set<String>> this$rejectedAttributes = this.rejectedAttributes;
        Map<String, Set<String>> other$rejectedAttributes = other.rejectedAttributes;
        if (this$rejectedAttributes == null ? other$rejectedAttributes != null : !((Object)this$rejectedAttributes).equals(other$rejectedAttributes)) {
            return false;
        }
        return this.caseInsensitive == other.caseInsensitive;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultRegisteredServiceAccessStrategy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.order;
        result = result * 59 + (this.enabled ? 79 : 97);
        result = result * 59 + (this.ssoEnabled ? 79 : 97);
        URI $unauthorizedRedirectUrl = this.unauthorizedRedirectUrl;
        result = result * 59 + ($unauthorizedRedirectUrl == null ? 43 : ((Object)$unauthorizedRedirectUrl).hashCode());
        RegisteredServiceDelegatedAuthenticationPolicy $delegatedAuthenticationPolicy = this.delegatedAuthenticationPolicy;
        result = result * 59 + ($delegatedAuthenticationPolicy == null ? 43 : $delegatedAuthenticationPolicy.hashCode());
        result = result * 59 + (this.requireAllAttributes ? 79 : 97);
        Map<String, Set<String>> $requiredAttributes = this.requiredAttributes;
        result = result * 59 + ($requiredAttributes == null ? 43 : ((Object)$requiredAttributes).hashCode());
        Map<String, Set<String>> $rejectedAttributes = this.rejectedAttributes;
        result = result * 59 + ($rejectedAttributes == null ? 43 : ((Object)$rejectedAttributes).hashCode());
        result = result * 59 + (this.caseInsensitive ? 79 : 97);
        return result;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setSsoEnabled(boolean ssoEnabled) {
        this.ssoEnabled = ssoEnabled;
    }

    @Generated
    public void setUnauthorizedRedirectUrl(URI unauthorizedRedirectUrl) {
        this.unauthorizedRedirectUrl = unauthorizedRedirectUrl;
    }

    @Generated
    public void setDelegatedAuthenticationPolicy(RegisteredServiceDelegatedAuthenticationPolicy delegatedAuthenticationPolicy) {
        this.delegatedAuthenticationPolicy = delegatedAuthenticationPolicy;
    }

    @Generated
    public void setRequireAllAttributes(boolean requireAllAttributes) {
        this.requireAllAttributes = requireAllAttributes;
    }

    @Generated
    public void setRequiredAttributes(Map<String, Set<String>> requiredAttributes) {
        this.requiredAttributes = requiredAttributes;
    }

    @Generated
    public void setRejectedAttributes(Map<String, Set<String>> rejectedAttributes) {
        this.rejectedAttributes = rejectedAttributes;
    }

    @Generated
    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }
}

