/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.io.IOException;
import org.apache.commons.lang3.ClassUtils;
import org.apereo.cas.authentication.principal.cache.CachingPrincipalAttributesRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JasigRegisteredServiceDeserializationProblemHandler
extends DeserializationProblemHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JasigRegisteredServiceDeserializationProblemHandler.class);
    private static final int TOKEN_COUNT_DURATION = 6;
    private static final int TOKEN_COUNT_EXPIRATION = 3;

    JasigRegisteredServiceDeserializationProblemHandler() {
    }

    public JavaType handleUnknownTypeId(DeserializationContext ctxt, JavaType baseType, String subTypeId, TypeIdResolver idResolver, String failureMsg) {
        try {
            if (subTypeId.contains("org.jasig.")) {
                String newTypeName = subTypeId.replaceAll("jasig", "apereo");
                LOGGER.warn("Found legacy CAS JSON definition type identified as [{}]. While CAS will attempt to convert the legacy definition to [{}] for the time being, the definition SHOULD manually be upgraded to the new supported syntax", (Object)subTypeId, (Object)newTypeName);
                Class newType = ClassUtils.getClass((String)newTypeName);
                return SimpleType.construct((Class)newType);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public boolean handleUnknownProperty(DeserializationContext ctxt, JsonParser p, JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException {
        boolean handled = false;
        if (beanOrClass instanceof CachingPrincipalAttributesRepository) {
            CachingPrincipalAttributesRepository repo = (CachingPrincipalAttributesRepository)CachingPrincipalAttributesRepository.class.cast(beanOrClass);
            switch (propertyName) {
                case "duration": {
                    for (int i = 1; i <= 6; ++i) {
                        p.nextToken();
                    }
                    String timeUnit = p.getText();
                    for (int i = 1; i <= 3; ++i) {
                        p.nextToken();
                    }
                    int expiration = p.getValueAsInt();
                    repo.setTimeUnit(timeUnit);
                    repo.setExpiration((long)expiration);
                    LOGGER.warn("CAS has converted legacy JSON property [{}] for type [{}]. It parsed 'expiration' value [{}] with time unit of [{}].It is STRONGLY recommended that you review the configuration and upgrade from the legacy syntax.", new Object[]{propertyName, beanOrClass.getClass().getName(), expiration, timeUnit});
                    handled = true;
                    break;
                }
            }
        }
        return handled;
    }
}

