/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.support;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apereo.cas.services.RegisteredServiceAttributeFilter;
import org.apereo.cas.services.support.RegisteredServiceMappedRegexAttributeFilter;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.ScriptingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredServiceScriptedAttributeFilter
implements RegisteredServiceAttributeFilter {
    private static final long serialVersionUID = 122972056984610198L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceMappedRegexAttributeFilter.class);
    private int order;
    private String script;

    public void setOrder(int order) {
        this.order = order;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public Map<String, Object> filter(Map<String, Object> givenAttributes) {
        Matcher matcherInline = ScriptingUtils.getMatcherForInlineGroovyScript((String)this.script);
        Matcher matcherFile = ScriptingUtils.getMatcherForExternalGroovyScript((String)this.script);
        if (matcherInline.find()) {
            return RegisteredServiceScriptedAttributeFilter.filterInlinedGroovyAttributeValues(givenAttributes, matcherInline.group(1));
        }
        if (matcherFile.find()) {
            return RegisteredServiceScriptedAttributeFilter.filterFileBasedGroovyAttributeValues(givenAttributes, matcherFile.group(1));
        }
        return givenAttributes;
    }

    private static Map<String, Object> getGroovyAttributeValue(String groovyScript, Map<String, Object> resolvedAttributes) {
        return (Map)ScriptingUtils.executeGroovyShellScript((String)groovyScript, (Map)CollectionUtils.wrap((String)"attributes", resolvedAttributes, (String)"logger", (Object)LOGGER));
    }

    private static Map<String, Object> filterInlinedGroovyAttributeValues(Map<String, Object> resolvedAttributes, String script) {
        LOGGER.debug("Found inline groovy script to execute [{}]", (Object)script);
        Map<String, Object> attributesToRelease = RegisteredServiceScriptedAttributeFilter.getGroovyAttributeValue(script, resolvedAttributes);
        return attributesToRelease;
    }

    private static Map<String, Object> filterFileBasedGroovyAttributeValues(Map<String, Object> resolvedAttributes, String scriptFile) {
        try {
            LOGGER.debug("Found groovy script file to execute [{}]", (Object)scriptFile);
            String script = FileUtils.readFileToString((File)new File(scriptFile), (Charset)StandardCharsets.UTF_8);
            Map<String, Object> attributesToRelease = RegisteredServiceScriptedAttributeFilter.getGroovyAttributeValue(script, resolvedAttributes);
            return attributesToRelease;
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new HashMap<String, Object>(0);
        }
    }

    public int getOrder() {
        return this.order;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("order", this.order).append("script", (Object)this.script).toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        RegisteredServiceScriptedAttributeFilter rhs = (RegisteredServiceScriptedAttributeFilter)obj;
        return new EqualsBuilder().append(this.order, rhs.order).append((Object)this.script, (Object)rhs.script).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.order).append((Object)this.script).toHashCode();
    }
}

