/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.support;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apereo.cas.services.RegisteredServiceAttributeFilter;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredServiceRegexAttributeFilter
implements RegisteredServiceAttributeFilter {
    private static final long serialVersionUID = 403015306984610128L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceRegexAttributeFilter.class);
    private Pattern pattern;
    private int order;

    protected RegisteredServiceRegexAttributeFilter() {
    }

    public RegisteredServiceRegexAttributeFilter(String regex) {
        this.pattern = Pattern.compile(regex);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Map<String, Object> filter(Map<String, Object> givenAttributes) {
        HashMap<String, Object> attributesToRelease = new HashMap<String, Object>();
        givenAttributes.entrySet().stream().filter((? super T entry) -> {
            String attributeName = (String)entry.getKey();
            Object attributeValue = entry.getValue();
            LOGGER.debug("Received attribute [{}] with value [{}]", (Object)attributeName, attributeValue);
            return attributeValue != null;
        }).forEach(entry -> {
            String attributeName = (String)entry.getKey();
            Object attributeValue = entry.getValue();
            if (attributeValue instanceof Collection) {
                LOGGER.trace("Attribute value [{}] is a collection", attributeValue);
                List filteredAttributes = this.filterAttributes((Collection)attributeValue, attributeName);
                if (!filteredAttributes.isEmpty()) {
                    attributesToRelease.put(attributeName, filteredAttributes);
                }
            } else if (attributeValue.getClass().isArray()) {
                LOGGER.trace("Attribute value [{}] is an array", attributeValue);
                List filteredAttributes = this.filterAttributes(CollectionUtils.wrapList((Object[])((String[])attributeValue)), attributeName);
                if (!filteredAttributes.isEmpty()) {
                    attributesToRelease.put(attributeName, filteredAttributes);
                }
            } else if (attributeValue instanceof Map) {
                LOGGER.trace("Attribute value [{}] is a map", attributeValue);
                Map<String, String> filteredAttributes = this.filterAttributes((Map)attributeValue);
                if (!filteredAttributes.isEmpty()) {
                    attributesToRelease.put(attributeName, filteredAttributes);
                }
            } else {
                LOGGER.trace("Attribute value [{}] is a string", attributeValue);
                String attrValue = attributeValue.toString();
                if (this.patternMatchesAttributeValue(attrValue)) {
                    this.logReleasedAttributeEntry(attributeName, attrValue);
                    attributesToRelease.put(attributeName, attrValue);
                }
            }
        });
        LOGGER.debug("Received [{}] attributes. Filtered and released [{}]", (Object)givenAttributes.size(), (Object)attributesToRelease.size());
        return attributesToRelease;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    private Map<String, String> filterAttributes(Map<String, String> valuesToFilter) {
        return valuesToFilter.entrySet().stream().filter((? super T entry) -> this.patternMatchesAttributeValue((String)entry.getValue())).map(entry -> {
            this.logReleasedAttributeEntry((String)entry.getKey(), (String)entry.getValue());
            return entry;
        }).collect(Collectors.toMap(Map.Entry::getKey, entry -> (String)valuesToFilter.get(entry.getKey()), (e, f) -> f == null ? e : f));
    }

    private List filterAttributes(Collection<String> valuesToFilter, String attributeName) {
        return valuesToFilter.stream().filter(this::patternMatchesAttributeValue).map(attributeValue -> {
            this.logReleasedAttributeEntry(attributeName, (String)attributeValue);
            return attributeValue;
        }).collect(Collectors.toList());
    }

    private boolean patternMatchesAttributeValue(String value) {
        return this.pattern.matcher(value).matches();
    }

    private void logReleasedAttributeEntry(String attributeName, String attributeValue) {
        LOGGER.debug("The attribute value [{}] for attribute name [{}] matches the pattern [{}]. Releasing attribute...", new Object[]{attributeValue, attributeName, this.pattern.pattern()});
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 83).append((Object)this.pattern).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        RegisteredServiceRegexAttributeFilter rhs = (RegisteredServiceRegexAttributeFilter)obj;
        return new EqualsBuilder().append((Object)this.pattern.pattern(), (Object)rhs.getPattern().pattern()).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("pattern", (Object)this.pattern.pattern()).toString();
    }
}

