/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.support;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apereo.cas.services.RegisteredServiceAttributeFilter;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.RegexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredServiceMappedRegexAttributeFilter
implements RegisteredServiceAttributeFilter {
    private static final long serialVersionUID = 852145306984610128L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceMappedRegexAttributeFilter.class);
    private Map<String, String> patterns;
    private boolean excludeUnmappedAttributes;
    private boolean completeMatch;
    private int order;

    public RegisteredServiceMappedRegexAttributeFilter() {
    }

    public RegisteredServiceMappedRegexAttributeFilter(Map<String, String> patterns) {
        this.patterns = patterns;
    }

    public Map<String, Object> filter(Map<String, Object> givenAttributes) {
        HashMap<String, Object> attributesToRelease = new HashMap<String, Object>();
        givenAttributes.entrySet().stream().filter((? super T entry) -> {
            String attributeName = (String)entry.getKey();
            Object attributeValue = entry.getValue();
            LOGGER.debug("Received attribute [{}] with value(s) [{}]", (Object)attributeName, attributeValue);
            return attributeValue != null;
        }).forEach(entry -> {
            String attributeName = (String)entry.getKey();
            if (this.patterns.containsKey(attributeName)) {
                Set attributeValues = CollectionUtils.toCollection(entry.getValue());
                Pattern pattern = RegexUtils.createPattern((String)this.patterns.get(attributeName));
                LOGGER.debug("Found attribute [{}] in the pattern definitions. Processing pattern [{}]", (Object)attributeName, (Object)pattern.pattern());
                List<Object> filteredValues = this.filterAttributeValuesByPattern(attributeValues, pattern);
                LOGGER.debug("Filtered attribute values for [{}] are [{}]", (Object)attributeName, filteredValues);
                if (filteredValues.isEmpty()) {
                    LOGGER.debug("Attribute [{}] has no values remaining and shall be excluded", (Object)attributeName);
                } else {
                    attributesToRelease.put(attributeName, filteredValues);
                }
            } else {
                LOGGER.debug("Found attribute [{}] that is not defined in pattern definitions", (Object)attributeName);
                if (this.excludeUnmappedAttributes) {
                    LOGGER.debug("Excluding attribute [{}] given unmatched attributes are to be excluded", (Object)attributeName);
                } else {
                    LOGGER.debug("Added unmatched attribute [{}] with value(s) [{}]", entry.getKey(), entry.getValue());
                    attributesToRelease.put((String)entry.getKey(), entry.getValue());
                }
            }
        });
        LOGGER.debug("Received [{}] attributes. Filtered and released [{}]", (Object)givenAttributes.size(), (Object)attributesToRelease.size());
        return attributesToRelease;
    }

    protected List<Object> filterAttributeValuesByPattern(Set<Object> attributeValues, Pattern pattern) {
        return attributeValues.stream().filter((? super T v) -> {
            Matcher matcher = pattern.matcher(v.toString());
            LOGGER.debug("Matching attribute value [{}] against pattern [{}]", v, (Object)pattern.pattern());
            if (this.completeMatch) {
                return matcher.matches();
            }
            return matcher.find();
        }).collect(Collectors.toList());
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Map<String, String> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(Map<String, String> patterns) {
        this.patterns = patterns;
    }

    public boolean isExcludeUnmappedAttributes() {
        return this.excludeUnmappedAttributes;
    }

    public boolean isCompleteMatch() {
        return this.completeMatch;
    }

    public void setCompleteMatch(boolean completeMatch) {
        this.completeMatch = completeMatch;
    }

    public void setExcludeUnmappedAttributes(boolean excludeUnmappedAttributes) {
        this.excludeUnmappedAttributes = excludeUnmappedAttributes;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        RegisteredServiceMappedRegexAttributeFilter rhs = (RegisteredServiceMappedRegexAttributeFilter)obj;
        return new EqualsBuilder().append(this.patterns, rhs.patterns).append(this.excludeUnmappedAttributes, rhs.excludeUnmappedAttributes).append(this.completeMatch, rhs.completeMatch).append(this.order, rhs.order).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.patterns).append(this.excludeUnmappedAttributes).append(this.completeMatch).append(this.order).toHashCode();
    }
}

