/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apereo.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.apereo.cas.util.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeBasedRegisteredServiceAccessStrategy
extends DefaultRegisteredServiceAccessStrategy {
    private static final long serialVersionUID = -6180748828025837047L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeBasedRegisteredServiceAccessStrategy.class);
    private String startingDateTime;
    private String endingDateTime;

    public TimeBasedRegisteredServiceAccessStrategy() {
    }

    public TimeBasedRegisteredServiceAccessStrategy(boolean enabled, boolean ssoEnabled) {
        super(enabled, ssoEnabled);
    }

    public String getStartingDateTime() {
        return this.startingDateTime;
    }

    public String getEndingDateTime() {
        return this.endingDateTime;
    }

    public void setStartingDateTime(String startingDateTime) {
        this.startingDateTime = startingDateTime;
    }

    public void setEndingDateTime(String endingDateTime) {
        this.endingDateTime = endingDateTime;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        TimeBasedRegisteredServiceAccessStrategy rhs = (TimeBasedRegisteredServiceAccessStrategy)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.startingDateTime, (Object)rhs.startingDateTime).append((Object)this.endingDateTime, (Object)rhs.endingDateTime).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.startingDateTime).append((Object)this.endingDateTime).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("startingDateTime", (Object)this.startingDateTime).append("endingDateTime", (Object)this.endingDateTime).toString();
    }

    @Override
    public boolean isServiceAccessAllowed() {
        if (!this.doesStartingTimeAllowServiceAccess()) {
            return false;
        }
        if (!this.doesEndingTimeAllowServiceAccess()) {
            return false;
        }
        return super.isServiceAccessAllowed();
    }

    protected boolean doesEndingTimeAllowServiceAccess() {
        if (this.endingDateTime != null) {
            ZonedDateTime et = DateTimeUtils.zonedDateTimeOf((String)this.endingDateTime);
            if (et != null) {
                if (ZonedDateTime.now().isAfter(et)) {
                    LOGGER.warn("Service access not allowed because it ended at [{}]. Now is [{}]", (Object)this.endingDateTime, (Object)ZonedDateTime.now());
                    return false;
                }
            } else {
                LocalDateTime etLocal = DateTimeUtils.localDateTimeOf((String)this.endingDateTime);
                if (etLocal != null && LocalDateTime.now().isAfter(etLocal)) {
                    LOGGER.warn("Service access not allowed because it ended at [{}]. Now is [{}]", (Object)this.endingDateTime, (Object)LocalDateTime.now());
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean doesStartingTimeAllowServiceAccess() {
        if (this.startingDateTime != null) {
            ZonedDateTime st = DateTimeUtils.zonedDateTimeOf((String)this.startingDateTime);
            if (st != null) {
                if (ZonedDateTime.now().isBefore(st)) {
                    LOGGER.warn("Service access not allowed because it starts at [{}]. Zoned now is [{}]", (Object)this.startingDateTime, (Object)ZonedDateTime.now());
                    return false;
                }
            } else {
                LocalDateTime stLocal = DateTimeUtils.localDateTimeOf((String)this.startingDateTime);
                if (stLocal != null && LocalDateTime.now().isBefore(stLocal)) {
                    LOGGER.warn("Service access not allowed because it starts at [{}]. Local now is [{}]", (Object)this.startingDateTime, (Object)ZonedDateTime.now());
                    return false;
                }
            }
        }
        return true;
    }
}

