/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.BaseRegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.ScriptingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptedRegisteredServiceUsernameProvider
extends BaseRegisteredServiceUsernameAttributeProvider {
    private static final long serialVersionUID = -678554831202936052L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptedRegisteredServiceUsernameProvider.class);
    private String script;

    public ScriptedRegisteredServiceUsernameProvider() {
    }

    public ScriptedRegisteredServiceUsernameProvider(String script) {
        this.script = script;
    }

    @Override
    protected String resolveUsernameInternal(Principal principal, Service service, RegisteredService registeredService) {
        try {
            LOGGER.debug("Found groovy script to execute");
            Object result = ScriptingUtils.executeGroovyScriptEngine((String)this.script, (Object[])new Object[]{principal.getAttributes(), principal.getId(), LOGGER});
            if (result != null) {
                LOGGER.debug("Found username [{}] from script [{}]", result, (Object)this.script);
                return result.toString();
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        LOGGER.warn("Script [{}] returned no value for username attribute. Fallback to default [{}]", (Object)this.script, (Object)principal.getId());
        return principal.getId();
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ScriptedRegisteredServiceUsernameProvider rhs = (ScriptedRegisteredServiceUsernameProvider)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.script, (Object)rhs.script).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.script).toHashCode();
    }
}

