/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.net.URL;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apereo.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.http.HttpMessage;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class RemoteEndpointServiceAccessStrategy
extends DefaultRegisteredServiceAccessStrategy {
    private static final long serialVersionUID = -1108201604115278440L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteEndpointServiceAccessStrategy.class);
    private String endpointUrl;
    private String acceptableResponseCodes;

    @Override
    public boolean doPrincipalAttributesAllowServiceAccess(String principal, Map<String, Object> principalAttributes) {
        try {
            if (super.doPrincipalAttributesAllowServiceAccess(principal, principalAttributes)) {
                HttpClient client = (HttpClient)ApplicationContextProvider.getApplicationContext().getBean("noRedirectHttpClient", HttpClient.class);
                URIBuilder builder = new URIBuilder(this.endpointUrl);
                builder.addParameter("username", principal);
                URL url = builder.build().toURL();
                HttpMessage message = client.sendMessageToEndPoint(url);
                LOGGER.debug("Message received from [{}] is [{}]", (Object)url, (Object)message);
                return message != null && StringUtils.commaDelimitedListToSet((String)this.acceptableResponseCodes).contains(String.valueOf(message.getResponseCode()));
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public void setEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    public String getAcceptableResponseCodes() {
        return this.acceptableResponseCodes;
    }

    public void setAcceptableResponseCodes(String acceptableResponseCodes) {
        this.acceptableResponseCodes = acceptableResponseCodes;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        RemoteEndpointServiceAccessStrategy rhs = (RemoteEndpointServiceAccessStrategy)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.endpointUrl, (Object)rhs.endpointUrl).append((Object)this.acceptableResponseCodes, (Object)rhs.acceptableResponseCodes).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.endpointUrl).append((Object)this.acceptableResponseCodes).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("endpointUrl", (Object)this.endpointUrl).append("acceptableResponseCodes", (Object)this.acceptableResponseCodes).toString();
    }
}

