/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URL;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apereo.cas.services.RegisteredServiceProxyPolicy;
import org.apereo.cas.util.RegexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexMatchingRegisteredServiceProxyPolicy
implements RegisteredServiceProxyPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegexMatchingRegisteredServiceProxyPolicy.class);
    private static final long serialVersionUID = -211069319543047324L;
    private String pattern;

    protected RegexMatchingRegisteredServiceProxyPolicy() {
        this.pattern = null;
    }

    @JsonCreator
    public RegexMatchingRegisteredServiceProxyPolicy(@JsonProperty(value="pattern") String pgtUrlPattern) {
        if (RegexUtils.isValidRegex((String)pgtUrlPattern)) {
            this.pattern = pgtUrlPattern;
        } else {
            LOGGER.warn("Pattern specified [{}] is not a valid regular expression", (Object)pgtUrlPattern);
            this.pattern = RegexUtils.MATCH_NOTHING_PATTERN.pattern();
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    @JsonIgnore
    public boolean isAllowedToProxy() {
        return true;
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 117).append((Object)this.pattern).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        RegexMatchingRegisteredServiceProxyPolicy rhs = (RegexMatchingRegisteredServiceProxyPolicy)obj;
        return new EqualsBuilder().append((Object)this.pattern, (Object)rhs.pattern).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.pattern).toString();
    }

    public boolean isAllowedProxyCallbackUrl(URL pgtUrl) {
        return RegexUtils.find((String)this.pattern, (String)pgtUrl.toExternalForm());
    }
}

