/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.BaseRegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.ScriptingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;

public class GroovyRegisteredServiceUsernameProvider
extends BaseRegisteredServiceUsernameAttributeProvider {
    private static final long serialVersionUID = 5823989148794052951L;
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyRegisteredServiceUsernameProvider.class);
    private String groovyScript;

    public GroovyRegisteredServiceUsernameProvider() {
    }

    public GroovyRegisteredServiceUsernameProvider(String groovyScript) {
        this.groovyScript = groovyScript;
    }

    @Override
    public String resolveUsernameInternal(Principal principal, Service service, RegisteredService registeredService) {
        Matcher matcherInline = ScriptingUtils.getMatcherForInlineGroovyScript((String)this.groovyScript);
        Matcher matcherFile = ScriptingUtils.getMatcherForExternalGroovyScript((String)this.groovyScript);
        if (matcherInline.find()) {
            return this.resolveUsernameFromInlineGroovyScript(principal, service, matcherInline.group(1));
        }
        if (matcherFile.find()) {
            return this.resolveUsernameFromExternalGroovyScript(principal, service, matcherFile.group(1));
        }
        LOGGER.warn("Groovy script [{}] is not valid. CAS will switch to use the default principal identifier [{}]", (Object)this.groovyScript, (Object)principal.getId());
        return principal.getId();
    }

    private String resolveUsernameFromExternalGroovyScript(Principal principal, Service service, String scriptFile) {
        try {
            LOGGER.debug("Found groovy script to execute");
            AbstractResource resourceFrom = ResourceUtils.getResourceFrom((String)scriptFile);
            String script = IOUtils.toString((InputStream)resourceFrom.getInputStream(), (Charset)StandardCharsets.UTF_8);
            Object result = GroovyRegisteredServiceUsernameProvider.getGroovyAttributeValue(principal, script);
            if (result != null) {
                LOGGER.debug("Found username [{}] from script [{}]", result, (Object)scriptFile);
                return result.toString();
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        LOGGER.warn("Groovy script [{}] returned no value for username attribute. Fallback to default [{}]", (Object)this.groovyScript, (Object)principal.getId());
        return principal.getId();
    }

    private String resolveUsernameFromInlineGroovyScript(Principal principal, Service service, String script) {
        try {
            LOGGER.debug("Found groovy script to execute [{}]", (Object)this.groovyScript);
            Object result = GroovyRegisteredServiceUsernameProvider.getGroovyAttributeValue(principal, script);
            if (result != null) {
                LOGGER.debug("Found username [{}] from script [{}]", result, (Object)this.groovyScript);
                return result.toString();
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        LOGGER.warn("Groovy script [{}] returned no value for username attribute. Fallback to default [{}]", (Object)this.groovyScript, (Object)principal.getId());
        return principal.getId();
    }

    private static Object getGroovyAttributeValue(Principal principal, String script) {
        return ScriptingUtils.executeGroovyShellScript((String)script, (Map)CollectionUtils.wrap((String)"attributes", (Object)principal.getAttributes(), (String)"id", (Object)principal.getId(), (String)"logger", (Object)LOGGER));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        GroovyRegisteredServiceUsernameProvider rhs = (GroovyRegisteredServiceUsernameProvider)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.groovyScript, (Object)rhs.groovyScript).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.groovyScript).toHashCode();
    }

    public String getGroovyScript() {
        return this.groovyScript;
    }

    public void setGroovyScript(String groovyScript) {
        this.groovyScript = groovyScript;
    }
}

