/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="RegexRegisteredServiceProperty")
public class DefaultRegisteredServiceProperty
implements RegisteredServiceProperty {
    private static final long serialVersionUID = 1349556364689133211L;
    @org.springframework.data.annotation.Id
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="native")
    @GenericGenerator(name="native", strategy="native")
    private long id;
    @Lob
    @Column(name="property_values")
    private HashSet<String> values = new HashSet();

    public Set<String> getValues() {
        if (this.values == null) {
            this.values = new HashSet();
        }
        return this.values;
    }

    @JsonIgnore
    public String getValue() {
        if (this.values.isEmpty()) {
            return null;
        }
        return this.values.iterator().next();
    }

    public boolean contains(String value) {
        return this.values.contains(value);
    }

    public void setValues(Set<String> values) {
        this.getValues().clear();
        if (values == null) {
            return;
        }
        this.getValues().addAll(values);
    }

    public void addValue(String value) {
        this.getValues().add(value);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultRegisteredServiceProperty rhs = (DefaultRegisteredServiceProperty)obj;
        return new EqualsBuilder().append(this.values, rhs.values).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.values).toHashCode();
    }
}

