/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.RegexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRegisteredServiceAccessStrategy
implements RegisteredServiceAccessStrategy {
    private static final long serialVersionUID = 1245279151345635245L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRegisteredServiceAccessStrategy.class);
    protected int order;
    protected boolean enabled = true;
    protected boolean ssoEnabled = true;
    protected URI unauthorizedRedirectUrl;
    protected boolean requireAllAttributes = true;
    protected Map<String, Set<String>> requiredAttributes = new HashMap<String, Set<String>>();
    protected Map<String, Set<String>> rejectedAttributes = new HashMap<String, Set<String>>();
    protected boolean caseInsensitive;

    public DefaultRegisteredServiceAccessStrategy() {
        this(true, true);
    }

    public DefaultRegisteredServiceAccessStrategy(boolean enabled, boolean ssoEnabled) {
        this.enabled = enabled;
        this.ssoEnabled = ssoEnabled;
    }

    public DefaultRegisteredServiceAccessStrategy(Map<String, Set<String>> requiredAttributes, Map<String, Set<String>> rejectedAttributes) {
        this();
        this.requiredAttributes = requiredAttributes;
        this.rejectedAttributes = rejectedAttributes;
    }

    public DefaultRegisteredServiceAccessStrategy(Map<String, Set<String>> requiredAttributes) {
        this();
        this.requiredAttributes = requiredAttributes;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setSsoEnabled(boolean ssoEnabled) {
        this.ssoEnabled = ssoEnabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isSsoEnabled() {
        return this.ssoEnabled;
    }

    public void setRequireAllAttributes(boolean requireAllAttributes) {
        this.requireAllAttributes = requireAllAttributes;
    }

    public boolean isRequireAllAttributes() {
        return this.requireAllAttributes;
    }

    public Map<String, Set<String>> getRequiredAttributes() {
        return new HashMap<String, Set<String>>(this.requiredAttributes);
    }

    public void setUnauthorizedRedirectUrl(URI unauthorizedRedirectUrl) {
        this.unauthorizedRedirectUrl = unauthorizedRedirectUrl;
    }

    public URI getUnauthorizedRedirectUrl() {
        return this.unauthorizedRedirectUrl;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public void setRequiredAttributes(Map<String, Set<String>> requiredAttributes) {
        this.requiredAttributes = requiredAttributes;
    }

    public void setRejectedAttributes(Map<String, Set<String>> rejectedAttributes) {
        this.rejectedAttributes = rejectedAttributes;
    }

    public Map<String, Set<String>> getRejectedAttributes() {
        return this.rejectedAttributes;
    }

    @JsonIgnore
    public boolean isServiceAccessAllowedForSso() {
        if (!this.ssoEnabled) {
            LOGGER.trace("Service is not authorized to participate in SSO.");
            return false;
        }
        return true;
    }

    @JsonIgnore
    public boolean isServiceAccessAllowed() {
        if (!this.enabled) {
            LOGGER.trace("Service is not enabled in service registry.");
            return false;
        }
        return true;
    }

    @JsonIgnore
    public void setServiceAccessAllowed(boolean value) {
        this.enabled = value;
    }

    public boolean doPrincipalAttributesAllowServiceAccess(String principal, Map<String, Object> principalAttributes) {
        if (this.rejectedAttributes.isEmpty() && this.requiredAttributes.isEmpty()) {
            LOGGER.debug("Skipping access strategy policy, since no attributes rules are defined");
            return true;
        }
        if (!this.enoughAttributesAvailableToProcess(principal, principalAttributes)) {
            LOGGER.debug("Access is denied. There are not enough attributes available to satisfy requirements");
            return false;
        }
        if (this.doRejectedAttributesRefusePrincipalAccess(principalAttributes)) {
            LOGGER.debug("Access is denied. The principal carries attributes that would reject service access");
            return false;
        }
        if (!this.doRequiredAttributesAllowPrincipalAccess(principalAttributes, this.requiredAttributes)) {
            LOGGER.debug("Access is denied. The principal does not have the required attributes specified by this strategy");
            return false;
        }
        return true;
    }

    protected boolean doRequiredAttributesAllowPrincipalAccess(Map<String, Object> principalAttributes, Map<String, Set<String>> requiredAttributes) {
        LOGGER.debug("These required attributes [{}] are examined against [{}] before service can proceed.", requiredAttributes, principalAttributes);
        if (requiredAttributes.isEmpty()) {
            return true;
        }
        return this.common(principalAttributes, requiredAttributes);
    }

    protected boolean doRejectedAttributesRefusePrincipalAccess(Map<String, Object> principalAttributes) {
        LOGGER.debug("These rejected attributes [{}] are examined against [{}] before service can proceed.", this.rejectedAttributes, principalAttributes);
        if (this.rejectedAttributes.isEmpty()) {
            return false;
        }
        return this.common(principalAttributes, this.rejectedAttributes);
    }

    protected boolean enoughAttributesAvailableToProcess(String principal, Map<String, Object> principalAttributes) {
        if (!this.enoughRequiredAttributesAvailableToProcess(principalAttributes, this.requiredAttributes)) {
            return false;
        }
        if (principalAttributes.size() < this.rejectedAttributes.size()) {
            LOGGER.debug("The size of the principal attributes that are [{}] does not match defined rejected attributes, which means the principal is not carrying enough data to grant authorization", principalAttributes);
            return false;
        }
        return true;
    }

    protected boolean enoughRequiredAttributesAvailableToProcess(Map<String, Object> principalAttributes, Map<String, Set<String>> requiredAttributes) {
        if (principalAttributes.isEmpty() && !requiredAttributes.isEmpty()) {
            LOGGER.debug("No principal attributes are found to satisfy defined attribute requirements");
            return false;
        }
        if (principalAttributes.size() < requiredAttributes.size()) {
            LOGGER.debug("The size of the principal attributes that are [{}] does not match defined required attributes, which indicates the principal is not carrying enough data to grant authorization", principalAttributes);
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultRegisteredServiceAccessStrategy rhs = (DefaultRegisteredServiceAccessStrategy)obj;
        return new EqualsBuilder().append(this.enabled, rhs.enabled).append(this.ssoEnabled, rhs.ssoEnabled).append(this.requireAllAttributes, rhs.requireAllAttributes).append(this.requiredAttributes, rhs.requiredAttributes).append((Object)this.unauthorizedRedirectUrl, (Object)rhs.unauthorizedRedirectUrl).append(this.caseInsensitive, rhs.caseInsensitive).append(this.rejectedAttributes, rhs.rejectedAttributes).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.enabled).append(this.ssoEnabled).append(this.requireAllAttributes).append(this.requiredAttributes).append((Object)this.unauthorizedRedirectUrl).append(this.caseInsensitive).append(this.rejectedAttributes).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("enabled", this.enabled).append("ssoEnabled", this.ssoEnabled).append("requireAllAttributes", this.requireAllAttributes).append("requiredAttributes", this.requiredAttributes).append("unauthorizedRedirectUrl", (Object)this.unauthorizedRedirectUrl).append("caseInsensitive", this.caseInsensitive).append("rejectedAttributes", this.rejectedAttributes).toString();
    }

    protected boolean common(Map<String, Object> principalAttributes, Map<String, Set<String>> attributes) {
        Set difference = attributes.keySet().stream().filter(a -> principalAttributes.keySet().contains(a)).collect(Collectors.toSet());
        if (this.requireAllAttributes && difference.size() < attributes.size()) {
            return false;
        }
        return difference.stream().anyMatch(key -> {
            Set values = (Set)attributes.get(key);
            Set availableValues = CollectionUtils.toCollection(principalAttributes.get(key));
            Pattern pattern = RegexUtils.concatenate((Collection)values, (boolean)this.caseInsensitive);
            if (pattern != RegexUtils.MATCH_NOTHING_PATTERN) {
                return availableValues.stream().map(Object::toString).anyMatch(pattern.asPredicate());
            }
            return availableValues.stream().anyMatch(values::contains);
        });
    }
}

