/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.Locale;
import javax.persistence.PostLoad;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.services.RegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.apereo.services.persondir.util.CaseCanonicalizationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public abstract class BaseRegisteredServiceUsernameAttributeProvider
implements RegisteredServiceUsernameAttributeProvider {
    private static final long serialVersionUID = -8381275200333399951L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseRegisteredServiceUsernameAttributeProvider.class);
    private String canonicalizationMode = CaseCanonicalizationMode.NONE.name();
    private boolean encryptUsername;

    public BaseRegisteredServiceUsernameAttributeProvider() {
        this.setCanonicalizationMode(CaseCanonicalizationMode.NONE.name());
    }

    public BaseRegisteredServiceUsernameAttributeProvider(String canonicalizationMode) {
        this.canonicalizationMode = canonicalizationMode;
    }

    public final String resolveUsername(Principal principal, Service service, RegisteredService registeredService) {
        String username = this.resolveUsernameInternal(principal, service, registeredService);
        if (this.canonicalizationMode == null) {
            this.canonicalizationMode = CaseCanonicalizationMode.NONE.name();
        }
        String uid = CaseCanonicalizationMode.valueOf((String)this.canonicalizationMode).canonicalize(username.trim(), Locale.getDefault());
        LOGGER.debug("Resolved username for [{}] is [{}]", (Object)service.getId(), (Object)uid);
        if (!this.encryptUsername) {
            return uid;
        }
        String encryptedId = this.encryptResolvedUsername(principal, service, registeredService, uid);
        if (StringUtils.isBlank((CharSequence)encryptedId)) {
            throw new IllegalArgumentException("Could not encrypt username " + uid + " for service " + service);
        }
        return encryptedId;
    }

    protected String encryptResolvedUsername(Principal principal, Service service, RegisteredService registeredService, String username) {
        ApplicationContext applicationContext = ApplicationContextProvider.getApplicationContext();
        RegisteredServiceCipherExecutor cipher = (RegisteredServiceCipherExecutor)applicationContext.getBean("registeredServiceCipherExecutor", RegisteredServiceCipherExecutor.class);
        return cipher.encode(username, registeredService);
    }

    @PostLoad
    public void initialize() {
        this.setCanonicalizationMode(CaseCanonicalizationMode.NONE.name());
    }

    protected abstract String resolveUsernameInternal(Principal var1, Service var2, RegisteredService var3);

    public String getCanonicalizationMode() {
        return this.canonicalizationMode;
    }

    public void setCanonicalizationMode(String canonicalizationMode) {
        this.canonicalizationMode = canonicalizationMode;
    }

    public boolean isEncryptUsername() {
        return this.encryptUsername;
    }

    public void setEncryptUsername(boolean encryptUsername) {
        this.encryptUsername = encryptUsername;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        BaseRegisteredServiceUsernameAttributeProvider rhs = (BaseRegisteredServiceUsernameAttributeProvider)obj;
        return new EqualsBuilder().append((Object)this.canonicalizationMode, (Object)rhs.canonicalizationMode).append(this.encryptUsername, rhs.encryptUsername).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.canonicalizationMode).append(this.encryptUsername).toHashCode();
    }
}

