/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apereo.cas.authentication.principal.PersistentIdGenerator;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ShibbolethCompatiblePersistentIdGenerator;
import org.apereo.cas.services.BaseRegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.RegisteredService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnonymousRegisteredServiceUsernameAttributeProvider
extends BaseRegisteredServiceUsernameAttributeProvider {
    private static final long serialVersionUID = 7050462900237284803L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AnonymousRegisteredServiceUsernameAttributeProvider.class);
    private PersistentIdGenerator persistentIdGenerator = new ShibbolethCompatiblePersistentIdGenerator(RandomStringUtils.randomAlphanumeric((int)16));

    public AnonymousRegisteredServiceUsernameAttributeProvider() {
    }

    public AnonymousRegisteredServiceUsernameAttributeProvider(PersistentIdGenerator persistentIdGenerator) {
        this.persistentIdGenerator = persistentIdGenerator;
    }

    public PersistentIdGenerator getPersistentIdGenerator() {
        return this.persistentIdGenerator;
    }

    @Override
    protected String resolveUsernameInternal(Principal principal, Service service, RegisteredService registeredService) {
        if (this.persistentIdGenerator == null) {
            throw new IllegalArgumentException("No persistent id generator is defined");
        }
        String id = this.persistentIdGenerator.generate(principal, new Service(){
            private static final long serialVersionUID = 178464253829044870L;

            public boolean matches(Service service) {
                return false;
            }

            public String getId() {
                return null;
            }
        });
        LOGGER.debug("Resolved username [{}] for anonymous access", (Object)id);
        return id;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AnonymousRegisteredServiceUsernameAttributeProvider rhs = (AnonymousRegisteredServiceUsernameAttributeProvider)obj;
        return this.persistentIdGenerator.equals(rhs.persistentIdGenerator);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(13, 113).toHashCode();
    }
}

