/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Inheritance;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apereo.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.apereo.cas.services.DefaultRegisteredServiceContact;
import org.apereo.cas.services.DefaultRegisteredServiceExpirationPolicy;
import org.apereo.cas.services.DefaultRegisteredServiceMultifactorPolicy;
import org.apereo.cas.services.DefaultRegisteredServiceProperty;
import org.apereo.cas.services.DefaultRegisteredServiceUsernameProvider;
import org.apereo.cas.services.RefuseRegisteredServiceProxyPolicy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceContact;
import org.apereo.cas.services.RegisteredServiceExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceMultifactorPolicy;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.services.RegisteredServiceProxyPolicy;
import org.apereo.cas.services.RegisteredServicePublicKey;
import org.apereo.cas.services.RegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.ReturnAllowedAttributeReleasePolicy;
import org.hibernate.annotations.GenericGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Id;

@Entity
@Inheritance
@DiscriminatorColumn(name="expression_type", length=50, discriminatorType=DiscriminatorType.STRING, columnDefinition="VARCHAR(50) DEFAULT 'regex'")
@Table(name="RegexRegisteredService")
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY)
public abstract class AbstractRegisteredService
implements RegisteredService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRegisteredService.class);
    private static final long serialVersionUID = 7645279151115635245L;
    @Column(length=255, updatable=true, insertable=true, nullable=false)
    protected String serviceId;
    @Column(length=255, updatable=true, insertable=true, nullable=false)
    private String name;
    @Column(length=255, updatable=true, insertable=true, nullable=true)
    private String theme;
    @Column(length=255, updatable=true, insertable=true, nullable=true)
    private String informationUrl;
    @Column(length=255, updatable=true, insertable=true, nullable=true)
    private String privacyUrl;
    @Id
    @javax.persistence.Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="native")
    @GenericGenerator(name="native", strategy="native")
    private long id = -1L;
    @Column(length=255, updatable=true, insertable=true, nullable=true)
    private String description;
    @Lob
    @Column(name="expiration_policy", nullable=true, length=0x7FFFFFFF)
    private RegisteredServiceExpirationPolicy expirationPolicy = new DefaultRegisteredServiceExpirationPolicy();
    @Lob
    @Column(name="proxy_policy", nullable=true, length=0x7FFFFFFF)
    private RegisteredServiceProxyPolicy proxyPolicy = new RefuseRegisteredServiceProxyPolicy();
    @Column(name="evaluation_order", nullable=false)
    private int evaluationOrder;
    @Lob
    @Column(name="username_attr", nullable=true, length=0x7FFFFFFF)
    private RegisteredServiceUsernameAttributeProvider usernameAttributeProvider = new DefaultRegisteredServiceUsernameProvider();
    @Column(name="logout_type", nullable=true)
    private RegisteredService.LogoutType logoutType = RegisteredService.LogoutType.BACK_CHANNEL;
    @Lob
    @Column(name="required_handlers", length=0x7FFFFFFF)
    private HashSet<String> requiredHandlers = new HashSet();
    @Lob
    @Column(name="attribute_release", nullable=true, length=0x7FFFFFFF)
    private RegisteredServiceAttributeReleasePolicy attributeReleasePolicy = new ReturnAllowedAttributeReleasePolicy();
    @Lob
    @Column(name="mfa_policy", nullable=true, length=0x7FFFFFFF)
    private RegisteredServiceMultifactorPolicy multifactorPolicy = new DefaultRegisteredServiceMultifactorPolicy();
    @Column(length=255, updatable=true, insertable=true, nullable=true)
    private String logo;
    @Column(name="logout_url")
    private URL logoutUrl;
    @Lob
    @Column(name="access_strategy", nullable=true, length=0x7FFFFFFF)
    private RegisteredServiceAccessStrategy accessStrategy = new DefaultRegisteredServiceAccessStrategy();
    @Lob
    @Column(name="public_key", nullable=true, length=0x7FFFFFFF)
    private RegisteredServicePublicKey publicKey;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinTable(name="RegisteredServiceImpl_Props")
    private Map<String, DefaultRegisteredServiceProperty> properties = new HashMap<String, DefaultRegisteredServiceProperty>();
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinTable(name="RegisteredService_Contacts")
    @OrderColumn
    private List<DefaultRegisteredServiceContact> contacts = new ArrayList<DefaultRegisteredServiceContact>();

    public long getId() {
        return this.id;
    }

    public String getInformationUrl() {
        return this.informationUrl;
    }

    public String getPrivacyUrl() {
        return this.privacyUrl;
    }

    public String getDescription() {
        return this.description;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getName() {
        return this.name;
    }

    public String getTheme() {
        return this.theme;
    }

    public RegisteredServiceProxyPolicy getProxyPolicy() {
        return this.proxyPolicy;
    }

    public RegisteredServiceAccessStrategy getAccessStrategy() {
        return this.accessStrategy;
    }

    public URL getLogoutUrl() {
        return this.logoutUrl;
    }

    @PostLoad
    public void postLoad() {
        if (this.proxyPolicy == null) {
            this.proxyPolicy = new RefuseRegisteredServiceProxyPolicy();
        }
        if (this.usernameAttributeProvider == null) {
            this.usernameAttributeProvider = new DefaultRegisteredServiceUsernameProvider();
        }
        if (this.logoutType == null) {
            this.logoutType = RegisteredService.LogoutType.BACK_CHANNEL;
        }
        if (this.requiredHandlers == null) {
            this.requiredHandlers = new HashSet();
        }
        if (this.accessStrategy == null) {
            this.accessStrategy = new DefaultRegisteredServiceAccessStrategy();
        }
        if (this.multifactorPolicy == null) {
            this.multifactorPolicy = new DefaultRegisteredServiceMultifactorPolicy();
        }
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, DefaultRegisteredServiceProperty>();
        }
        if (this.attributeReleasePolicy == null) {
            this.attributeReleasePolicy = new ReturnAllowedAttributeReleasePolicy();
        }
        if (this.contacts == null) {
            this.contacts = new ArrayList<DefaultRegisteredServiceContact>();
        }
        if (this.expirationPolicy == null) {
            this.expirationPolicy = new DefaultRegisteredServiceExpirationPolicy();
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractRegisteredService)) {
            return false;
        }
        AbstractRegisteredService that = (AbstractRegisteredService)o;
        EqualsBuilder builder = new EqualsBuilder();
        return builder.append((Object)this.proxyPolicy, (Object)that.proxyPolicy).append(this.evaluationOrder, that.evaluationOrder).append((Object)this.description, (Object)that.description).append((Object)this.name, (Object)that.name).append((Object)this.serviceId, (Object)that.serviceId).append((Object)this.theme, (Object)that.theme).append((Object)this.usernameAttributeProvider, (Object)that.usernameAttributeProvider).append((Object)this.logoutType, (Object)that.logoutType).append((Object)this.attributeReleasePolicy, (Object)that.attributeReleasePolicy).append((Object)this.accessStrategy, (Object)that.accessStrategy).append((Object)this.logo, (Object)that.logo).append((Object)this.publicKey, (Object)that.publicKey).append((Object)this.logoutUrl, (Object)that.logoutUrl).append(this.requiredHandlers, that.requiredHandlers).append((Object)this.proxyPolicy, (Object)that.proxyPolicy).append(this.properties, that.properties).append((Object)this.multifactorPolicy, (Object)that.multifactorPolicy).append((Object)this.informationUrl, (Object)that.informationUrl).append((Object)this.privacyUrl, (Object)that.privacyUrl).append(this.contacts, that.contacts).append((Object)this.expirationPolicy, (Object)that.expirationPolicy).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 31).append((Object)this.description).append((Object)this.serviceId).append((Object)this.name).append((Object)this.theme).append(this.evaluationOrder).append((Object)this.usernameAttributeProvider).append((Object)this.accessStrategy).append((Object)this.logoutType).append((Object)this.attributeReleasePolicy).append((Object)this.accessStrategy).append((Object)this.logo).append((Object)this.publicKey).append((Object)this.logoutUrl).append(this.requiredHandlers).append((Object)this.proxyPolicy).append(this.properties).append((Object)this.multifactorPolicy).append((Object)this.informationUrl).append((Object)this.privacyUrl).append(this.contacts).append((Object)this.expirationPolicy).toHashCode();
    }

    public void setProxyPolicy(RegisteredServiceProxyPolicy policy) {
        this.proxyPolicy = policy;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public abstract void setServiceId(String var1);

    public void setId(long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public void setEvaluationOrder(int evaluationOrder) {
        this.evaluationOrder = evaluationOrder;
    }

    public int getEvaluationOrder() {
        return this.evaluationOrder;
    }

    public RegisteredServiceUsernameAttributeProvider getUsernameAttributeProvider() {
        return this.usernameAttributeProvider;
    }

    public void setAccessStrategy(RegisteredServiceAccessStrategy accessStrategy) {
        this.accessStrategy = accessStrategy;
    }

    public void setLogoutUrl(URL logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    public void setInformationUrl(String informationUrl) {
        this.informationUrl = informationUrl;
    }

    public void setPrivacyUrl(String privacyUrl) {
        this.privacyUrl = privacyUrl;
    }

    public void setUsernameAttributeProvider(RegisteredServiceUsernameAttributeProvider usernameProvider) {
        this.usernameAttributeProvider = usernameProvider;
    }

    public RegisteredService.LogoutType getLogoutType() {
        return this.logoutType;
    }

    public void setLogoutType(RegisteredService.LogoutType logoutType) {
        this.logoutType = logoutType;
    }

    public AbstractRegisteredService clone() {
        AbstractRegisteredService clone = this.newInstance();
        clone.copyFrom(this);
        return clone;
    }

    public void copyFrom(RegisteredService source) {
        this.setId(source.getId());
        this.setProxyPolicy(source.getProxyPolicy());
        this.setDescription(source.getDescription());
        this.setName(source.getName());
        this.setServiceId(source.getServiceId());
        this.setTheme(source.getTheme());
        this.setEvaluationOrder(source.getEvaluationOrder());
        this.setUsernameAttributeProvider(source.getUsernameAttributeProvider());
        this.setLogoutType(source.getLogoutType());
        this.setAttributeReleasePolicy(source.getAttributeReleasePolicy());
        this.setAccessStrategy(source.getAccessStrategy());
        this.setLogo(source.getLogo());
        this.setLogoutUrl(source.getLogoutUrl());
        this.setPublicKey(source.getPublicKey());
        this.setRequiredHandlers(source.getRequiredHandlers());
        this.setProperties(source.getProperties());
        this.setMultifactorPolicy(source.getMultifactorPolicy());
        this.setInformationUrl(source.getInformationUrl());
        this.setPrivacyUrl(source.getPrivacyUrl());
        this.setContacts(source.getContacts());
        this.setExpirationPolicy(source.getExpirationPolicy());
    }

    public int compareTo(RegisteredService other) {
        return new CompareToBuilder().append(this.getEvaluationOrder(), other.getEvaluationOrder()).append((Object)((String)StringUtils.defaultIfBlank((CharSequence)this.getName(), (CharSequence)"")).toLowerCase(), (Object)((String)StringUtils.defaultIfBlank((CharSequence)other.getName(), (CharSequence)"")).toLowerCase()).append((Object)this.getServiceId(), (Object)other.getServiceId()).append(this.getId(), other.getId()).toComparison();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(null, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("id", this.id);
        builder.append("name", (Object)this.name);
        builder.append("description", (Object)this.description);
        builder.append("serviceId", (Object)this.serviceId);
        builder.append("usernameAttributeProvider", (Object)this.usernameAttributeProvider);
        builder.append("theme", (Object)this.theme);
        builder.append("evaluationOrder", this.evaluationOrder);
        builder.append("logoutType", (Object)this.logoutType);
        builder.append("attributeReleasePolicy", (Object)this.attributeReleasePolicy);
        builder.append("accessStrategy", (Object)this.accessStrategy);
        builder.append("publicKey", (Object)this.publicKey);
        builder.append("proxyPolicy", (Object)this.proxyPolicy);
        builder.append("logo", (Object)this.logo);
        builder.append("logoutUrl", (Object)this.logoutUrl);
        builder.append("requiredHandlers", this.requiredHandlers);
        builder.append("properties", this.properties);
        builder.append("multifactorPolicy", (Object)this.multifactorPolicy);
        builder.append("informationUrl", (Object)this.informationUrl);
        builder.append("privacyUrl", (Object)this.privacyUrl);
        builder.append("contacts", this.contacts);
        builder.append("expirationPolicy", (Object)this.expirationPolicy);
        return builder.toString();
    }

    protected abstract AbstractRegisteredService newInstance();

    public Set<String> getRequiredHandlers() {
        if (this.requiredHandlers == null) {
            this.requiredHandlers = new HashSet();
        }
        return this.requiredHandlers;
    }

    public void setRequiredHandlers(Set<String> handlers) {
        this.getRequiredHandlers().clear();
        if (handlers == null) {
            return;
        }
        this.getRequiredHandlers().addAll(handlers);
    }

    public void setAttributeReleasePolicy(RegisteredServiceAttributeReleasePolicy policy) {
        this.attributeReleasePolicy = policy;
    }

    public RegisteredServiceAttributeReleasePolicy getAttributeReleasePolicy() {
        return this.attributeReleasePolicy;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public RegisteredServicePublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(RegisteredServicePublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public Map<String, RegisteredServiceProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, RegisteredServiceProperty> properties) {
        this.properties = properties;
    }

    public RegisteredServiceMultifactorPolicy getMultifactorPolicy() {
        return this.multifactorPolicy;
    }

    public void setMultifactorPolicy(RegisteredServiceMultifactorPolicy multifactorPolicy) {
        this.multifactorPolicy = multifactorPolicy;
    }

    public List<RegisteredServiceContact> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<RegisteredServiceContact> contacts) {
        this.contacts = contacts;
    }

    public RegisteredServiceExpirationPolicy getExpirationPolicy() {
        return this.expirationPolicy;
    }

    public void setExpirationPolicy(RegisteredServiceExpirationPolicy expirationPolicy) {
        this.expirationPolicy = expirationPolicy;
    }
}

