/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apereo.cas.authentication.principal.PersistentIdGenerator;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.gen.DefaultRandomStringGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShibbolethCompatiblePersistentIdGenerator
implements PersistentIdGenerator {
    private static final long serialVersionUID = 6182838799563190289L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ShibbolethCompatiblePersistentIdGenerator.class);
    private static final String CONST_SEPARATOR = "!";
    private static final int CONST_DEFAULT_SALT_COUNT = 16;
    @JsonProperty
    private String salt;
    @JsonProperty
    private String attribute;

    public ShibbolethCompatiblePersistentIdGenerator() {
    }

    public ShibbolethCompatiblePersistentIdGenerator(String salt) {
        this.salt = salt;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public String generate(String principal, String service) {
        if (StringUtils.isBlank((CharSequence)this.salt)) {
            this.salt = new DefaultRandomStringGenerator(16).getNewString();
        }
        String data = String.join((CharSequence)CONST_SEPARATOR, service, principal);
        String result = StringUtils.remove((String)DigestUtils.shaBase64((String)this.salt, (String)data, (String)CONST_SEPARATOR), (String)System.getProperty("line.separator"));
        LOGGER.debug("Generated persistent id for [{}] is [{}]", (Object)data, (Object)result);
        return result;
    }

    public String generate(Principal principal, Service service) {
        Map attributes = principal.getAttributes();
        String principalId = StringUtils.isNotBlank((CharSequence)this.attribute) && attributes.containsKey(this.attribute) ? attributes.get(this.attribute).toString() : principal.getId();
        return this.generate(principalId, service.getId());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ShibbolethCompatiblePersistentIdGenerator rhs = (ShibbolethCompatiblePersistentIdGenerator)obj;
        return new EqualsBuilder().append((Object)this.salt, (Object)rhs.salt).append((Object)this.attribute, (Object)rhs.attribute).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.salt).append((Object)this.attribute).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("attribute", (Object)this.attribute).append("salt", (Object)StringUtils.abbreviate((String)this.salt, (int)2)).toString();
    }
}

