/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.authentication.AuthenticationManager;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.support.DefaultCasProtocolAttributeEncoder;
import org.apereo.cas.authentication.support.NoOpProtocolAttributeEncoder;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.services.ServicesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="casCoreServicesAuthenticationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnBean(value={AuthenticationManager.class, ServicesManager.class})
public class CasCoreServicesAuthenticationConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreServicesAuthenticationConfiguration.class);
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="cacheCredentialsCipherExecutor")
    private ObjectProvider<CipherExecutor> cacheCredentialsCipherExecutor;
    @Autowired
    @Qualifier(value="registeredServiceCipherExecutor")
    private ObjectProvider<RegisteredServiceCipherExecutor> registeredServiceCipherExecutor;

    @Bean
    public ProtocolAttributeEncoder noOpCasAttributeEncoder() {
        return new NoOpProtocolAttributeEncoder();
    }

    @ConditionalOnMissingBean(name={"casAttributeEncoder"})
    @RefreshScope
    @Bean
    public ProtocolAttributeEncoder casAttributeEncoder() {
        return new DefaultCasProtocolAttributeEncoder((ServicesManager)this.servicesManager.getIfAvailable(), (RegisteredServiceCipherExecutor)this.registeredServiceCipherExecutor.getIfAvailable(), (CipherExecutor)this.cacheCredentialsCipherExecutor.getIfAvailable());
    }
}

