/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collection;
import org.apache.commons.lang3.ObjectUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.services.ServiceRegistryProperties;
import org.apereo.cas.configuration.model.support.services.json.JsonServiceRegistryProperties;
import org.apereo.cas.services.AbstractResourceBasedServiceRegistryDao;
import org.apereo.cas.services.ServiceRegistryDao;
import org.apereo.cas.services.ServiceRegistryInitializer;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.util.CasAddonsRegisteredServicesJsonSerializer;
import org.apereo.cas.services.util.DefaultRegisteredServiceJsonSerializer;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@Configuration(value="casServiceRegistryInitializationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnMissingClass(value={"org.apereo.cas.services.JsonServiceRegistryDao", "org.apereo.cas.services.YamlServiceRegistryDao"})
public class CasServiceRegistryInitializationConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(CasServiceRegistryInitializationConfiguration.class);
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private CasConfigurationProperties casProperties;

    @RefreshScope
    @Autowired
    @Bean
    public ServiceRegistryInitializer serviceRegistryInitializer(@Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="serviceRegistryDao") ServiceRegistryDao serviceRegistryDao) {
        ServiceRegistryProperties serviceRegistry = this.casProperties.getServiceRegistry();
        ServiceRegistryInitializer initializer = new ServiceRegistryInitializer(this.embeddedJsonServiceRegistry(), serviceRegistryDao, servicesManager, serviceRegistry.isInitFromJson());
        if (serviceRegistry.isInitFromJson()) {
            LOGGER.info("Attempting to initialize the service registry [{}] from service definition resources found at [{}]", (Object)serviceRegistryDao.toString(), (Object)this.getServiceRegistryInitializerServicesDirectoryResource());
        }
        initializer.initServiceRegistryIfNecessary();
        return initializer;
    }

    @RefreshScope
    @Bean
    public ServiceRegistryDao embeddedJsonServiceRegistry() {
        try {
            Resource location = this.getServiceRegistryInitializerServicesDirectoryResource();
            return new EmbeddedServiceRegistryDao(this.eventPublisher, location);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private Resource getServiceRegistryInitializerServicesDirectoryResource() {
        JsonServiceRegistryProperties registry = this.casProperties.getServiceRegistry().getJson();
        return (Resource)ObjectUtils.defaultIfNull((Object)registry.getLocation(), (Object)new ClassPathResource("services"));
    }

    public static class EmbeddedServiceRegistryDao
    extends AbstractResourceBasedServiceRegistryDao {
        EmbeddedServiceRegistryDao(ApplicationEventPublisher publisher, Resource location) throws Exception {
            super(location, (Collection)CollectionUtils.wrapList((Object[])new StringSerializer[]{new CasAddonsRegisteredServicesJsonSerializer(), new DefaultRegisteredServiceJsonSerializer()}), false, publisher);
        }

        protected String getExtension() {
            return "json";
        }
    }
}

