/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apereo.cas.authentication.DefaultMultifactorTriggerSelectionStrategy;
import org.apereo.cas.authentication.MultifactorTriggerSelectionStrategy;
import org.apereo.cas.authentication.principal.DefaultWebApplicationResponseBuilderLocator;
import org.apereo.cas.authentication.principal.PersistentIdGenerator;
import org.apereo.cas.authentication.principal.ResponseBuilder;
import org.apereo.cas.authentication.principal.ResponseBuilderLocator;
import org.apereo.cas.authentication.principal.ShibbolethCompatiblePersistentIdGenerator;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.authentication.principal.WebApplicationServiceResponseBuilder;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProperties;
import org.apereo.cas.services.DefaultServicesManager;
import org.apereo.cas.services.DomainServicesManager;
import org.apereo.cas.services.InMemoryServiceRegistry;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.services.RegisteredServicesEventListener;
import org.apereo.cas.services.ServiceRegistryDao;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.util.DefaultRegisteredServiceCipherExecutor;
import org.apereo.cas.util.io.CommunicationsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="casCoreServicesConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasCoreServicesConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreServicesConfiguration.class);
    @Autowired
    @Qualifier(value="communicationsManager")
    private CommunicationsManager communicationsManager;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ApplicationContext applicationContext;

    @RefreshScope
    @Bean
    public MultifactorTriggerSelectionStrategy defaultMultifactorTriggerSelectionStrategy() {
        MultifactorAuthenticationProperties mfa = this.casProperties.getAuthn().getMfa();
        String attributeNameTriggers = mfa.getGlobalPrincipalAttributeNameTriggers();
        String requestParameter = mfa.getRequestParameter();
        return new DefaultMultifactorTriggerSelectionStrategy(attributeNameTriggers, requestParameter);
    }

    @RefreshScope
    @Bean
    public PersistentIdGenerator shibbolethCompatiblePersistentIdGenerator() {
        return new ShibbolethCompatiblePersistentIdGenerator();
    }

    @ConditionalOnMissingBean(name={"webApplicationResponseBuilderLocator"})
    @Bean
    public ResponseBuilderLocator webApplicationResponseBuilderLocator() {
        return new DefaultWebApplicationResponseBuilderLocator(this.applicationContext);
    }

    @ConditionalOnMissingBean(name={"webApplicationServiceResponseBuilder"})
    @Bean
    public ResponseBuilder<WebApplicationService> webApplicationServiceResponseBuilder() {
        return new WebApplicationServiceResponseBuilder();
    }

    @ConditionalOnMissingBean(name={"registeredServiceCipherExecutor"})
    @Bean
    @RefreshScope
    public RegisteredServiceCipherExecutor registeredServiceCipherExecutor() {
        return new DefaultRegisteredServiceCipherExecutor();
    }

    @ConditionalOnMissingBean(name={"servicesManager"})
    @Bean
    @RefreshScope
    public ServicesManager servicesManager(@Qualifier(value="serviceRegistryDao") ServiceRegistryDao serviceRegistryDao) {
        switch (this.casProperties.getServiceRegistry().getManagementType()) {
            case DOMAIN: {
                LOGGER.debug("Managing CAS service definitions via domains");
                return new DomainServicesManager(serviceRegistryDao, this.eventPublisher);
            }
        }
        return new DefaultServicesManager(serviceRegistryDao, this.eventPublisher);
    }

    @Bean
    @RefreshScope
    public RegisteredServicesEventListener registeredServicesEventListener(@Qualifier(value="servicesManager") ServicesManager servicesManager) {
        return new RegisteredServicesEventListener(servicesManager, this.casProperties, this.communicationsManager);
    }

    @ConditionalOnMissingBean(name={"serviceRegistryDao"})
    @Bean
    @RefreshScope
    public ServiceRegistryDao serviceRegistryDao() {
        LOGGER.warn("Runtime memory is used as the persistence storage for retrieving and persisting service definitions. Changes that are made to service definitions during runtime WILL be LOST upon container restarts. Ideally for production, you need to choose a storage option (JDBC, etc) to store and track service definitions.");
        ArrayList services = new ArrayList();
        if (this.applicationContext.containsBean("inMemoryRegisteredServices")) {
            services.addAll((Collection)this.applicationContext.getBean("inMemoryRegisteredServices", List.class));
            LOGGER.debug("Found a list of registered services in the application context. Registering services [{}]", services);
        }
        return new InMemoryServiceRegistry(services);
    }
}

