/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.CipherExecutor;
import org.apereo.cas.authentication.AuthenticationManager;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.support.DefaultCasProtocolAttributeEncoder;
import org.apereo.cas.authentication.support.NoOpProtocolAttributeEncoder;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.services.ServicesManager;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="casCoreServicesAuthenticationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnBean(value={AuthenticationManager.class})
public class CasCoreServicesAuthenticationConfiguration {
    @Bean
    public ProtocolAttributeEncoder noOpCasAttributeEncoder() {
        return new NoOpProtocolAttributeEncoder();
    }

    @ConditionalOnMissingBean(name={"casAttributeEncoder"})
    @RefreshScope
    @Bean
    public ProtocolAttributeEncoder casAttributeEncoder(@Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="cacheCredentialsCipherExecutor") CipherExecutor cacheCredentialsCipherExecutor, @Qualifier(value="registeredServiceCipherExecutor") RegisteredServiceCipherExecutor registeredServiceCipherExecutor) {
        return new DefaultCasProtocolAttributeEncoder(servicesManager, registeredServiceCipherExecutor, cacheCredentialsCipherExecutor);
    }
}

