/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support;

import java.io.Serializable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.web.support.CookieValueManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptedCookieValueManager
implements CookieValueManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptedCookieValueManager.class);
    private final CipherExecutor<Serializable, Serializable> cipherExecutor;

    @Override
    public final String buildCookieValue(String givenCookieValue, HttpServletRequest request) {
        String res = this.buildCompoundCookieValue(givenCookieValue, request);
        LOGGER.debug("Encoding cookie value [{}]", (Object)res);
        return ((Serializable)this.cipherExecutor.encode((Object)res, new Object[0])).toString();
    }

    @Override
    public final String obtainCookieValue(Cookie cookie, HttpServletRequest request) {
        String cookieValue = ((Serializable)this.cipherExecutor.decode((Object)cookie.getValue(), new Object[0])).toString();
        LOGGER.debug("Decoded cookie value is [{}]", (Object)cookieValue);
        if (StringUtils.isBlank((CharSequence)cookieValue)) {
            LOGGER.debug("Retrieved decoded cookie value is blank. Failed to decode cookie [{}]", (Object)cookie.getName());
            return null;
        }
        return this.obtainValueFromCompoundCookie(cookieValue, request);
    }

    protected String buildCompoundCookieValue(String cookieValue, HttpServletRequest request) {
        return cookieValue;
    }

    protected String obtainValueFromCompoundCookie(String compoundValue, HttpServletRequest request) {
        return compoundValue;
    }

    @Generated
    public EncryptedCookieValueManager(CipherExecutor<Serializable, Serializable> cipherExecutor) {
        this.cipherExecutor = cipherExecutor;
    }
}

