/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support;

import com.google.common.base.Splitter;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.web.support.EncryptedCookieValueManager;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCasCookieValueManager
extends EncryptedCookieValueManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCasCookieValueManager.class);
    private static final char COOKIE_FIELD_SEPARATOR = '@';
    private static final int COOKIE_FIELDS_LENGTH = 3;

    public DefaultCasCookieValueManager(CipherExecutor<Serializable, Serializable> cipherExecutor) {
        super(cipherExecutor);
    }

    @Override
    protected String buildCompoundCookieValue(String givenCookieValue, HttpServletRequest request) {
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        StringBuilder builder = new StringBuilder(givenCookieValue).append('@').append(clientInfo.getClientIpAddress());
        String userAgent = HttpRequestUtils.getHttpServletRequestUserAgent((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userAgent)) {
            throw new IllegalStateException("Request does not specify a user-agent");
        }
        builder.append('@').append(userAgent);
        return builder.toString();
    }

    @Override
    protected String obtainValueFromCompoundCookie(String cookieValue, HttpServletRequest request) {
        List cookieParts = Splitter.on((String)String.valueOf('@')).splitToList((CharSequence)cookieValue);
        if (cookieParts.size() != 3) {
            throw new IllegalStateException("Invalid cookie. Required fields are missing");
        }
        String value = (String)cookieParts.get(0);
        String remoteAddr = (String)cookieParts.get(1);
        String userAgent = (String)cookieParts.get(2);
        if (StringUtils.isBlank((CharSequence)value) || StringUtils.isBlank((CharSequence)remoteAddr) || StringUtils.isBlank((CharSequence)userAgent)) {
            throw new IllegalStateException("Invalid cookie. Required fields are empty");
        }
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        if (!remoteAddr.equals(clientInfo.getClientIpAddress())) {
            throw new IllegalStateException("Invalid cookie. Required remote address " + remoteAddr + " does not match " + clientInfo.getClientIpAddress());
        }
        String agent = HttpRequestUtils.getHttpServletRequestUserAgent((HttpServletRequest)request);
        if (!userAgent.equals(agent)) {
            throw new IllegalStateException("Invalid cookie. Required user-agent " + userAgent + " does not match " + agent);
        }
        return value;
    }
}

