/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support;

import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.support.CookieValueManager;
import org.apereo.cas.web.support.NoOpCookieValueManager;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.execution.RequestContext;

public class CookieRetrievingCookieGenerator
extends CookieGenerator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CookieRetrievingCookieGenerator.class);
    private static final int DEFAULT_REMEMBER_ME_MAX_AGE = 7889231;
    private int rememberMeMaxAge = 7889231;
    private final CookieValueManager casCookieValueManager;

    public CookieRetrievingCookieGenerator(String name, String path, int maxAge, boolean secure, String domain, boolean httpOnly) {
        this(name, path, maxAge, secure, domain, new NoOpCookieValueManager(), 7889231, httpOnly);
    }

    public CookieRetrievingCookieGenerator(String name, String path, int maxAge, boolean secure, String domain, boolean httpOnly, CookieValueManager cookieValueManager) {
        this(name, path, maxAge, secure, domain, cookieValueManager, 7889231, httpOnly);
    }

    public CookieRetrievingCookieGenerator(String name, String path, int maxAge, boolean secure, String domain, CookieValueManager casCookieValueManager, int rememberMeMaxAge, boolean httpOnly) {
        super.setCookieName(name);
        super.setCookiePath(path);
        this.setCookieDomain(domain);
        super.setCookieMaxAge(Integer.valueOf(maxAge));
        super.setCookieSecure(secure);
        super.setCookieHttpOnly(httpOnly);
        this.casCookieValueManager = casCookieValueManager;
        this.rememberMeMaxAge = rememberMeMaxAge;
    }

    public void addCookie(RequestContext requestContext, String cookieValue) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        String theCookieValue = this.casCookieValueManager.buildCookieValue(cookieValue, request);
        if (this.isRememberMeAuthentication(requestContext).booleanValue()) {
            LOGGER.debug("Creating cookie [{}] for remember-me authentication with max-age [{}]", (Object)this.getCookieName(), (Object)this.rememberMeMaxAge);
            Cookie cookie = this.createCookie(theCookieValue);
            cookie.setMaxAge(this.rememberMeMaxAge);
            cookie.setSecure(this.isCookieSecure());
            cookie.setHttpOnly(this.isCookieHttpOnly());
            cookie.setComment("CAS Cookie w/ Remember-Me");
            response.addCookie(cookie);
        } else {
            LOGGER.debug("Creating cookie [{}]", (Object)this.getCookieName());
            super.addCookie(response, theCookieValue);
        }
    }

    public void addCookie(HttpServletRequest request, HttpServletResponse response, String cookieValue) {
        String theCookieValue = this.casCookieValueManager.buildCookieValue(cookieValue, request);
        LOGGER.debug("Creating cookie [{}]", (Object)this.getCookieName());
        super.addCookie(response, theCookieValue);
    }

    private Boolean isRememberMeAuthentication(RequestContext requestContext) {
        boolean isRememberMe;
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        String value = request.getParameter("rememberMe");
        LOGGER.debug("Locating request parameter [{}] with value [{}]", (Object)"rememberMe", (Object)value);
        boolean bl = isRememberMe = StringUtils.isNotBlank((CharSequence)value) && WebUtils.isRememberMeAuthenticationEnabled((RequestContext)requestContext) != false;
        if (!isRememberMe) {
            LOGGER.debug("Request does not indicate a remember-me authentication event. Locating authentication object from the request context...");
            Authentication auth = WebUtils.getAuthentication((RequestContext)requestContext);
            if (auth != null) {
                Map attributes = auth.getAttributes();
                LOGGER.debug("Located authentication attributes [{}]", (Object)attributes);
                if (attributes.containsKey("org.apereo.cas.authentication.principal.REMEMBER_ME")) {
                    boolean rememberMeValue = attributes.getOrDefault("org.apereo.cas.authentication.principal.REMEMBER_ME", Boolean.FALSE);
                    LOGGER.debug("Located remember-me authentication attribute [{}]", (Object)rememberMeValue);
                    isRememberMe = CollectionUtils.wrapSet((Object)rememberMeValue).contains(Boolean.TRUE);
                }
            }
        }
        LOGGER.debug("Is this request from a remember-me authentication event? [{}]", (Object)BooleanUtils.toStringYesNo((boolean)isRememberMe));
        return isRememberMe;
    }

    public String retrieveCookieValue(HttpServletRequest request) {
        try {
            Cookie cookie = org.springframework.web.util.WebUtils.getCookie((HttpServletRequest)request, (String)this.getCookieName());
            return cookie == null ? null : this.casCookieValueManager.obtainCookieValue(cookie, request);
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void setCookieDomain(String cookieDomain) {
        super.setCookieDomain((String)StringUtils.defaultIfEmpty((CharSequence)cookieDomain, null));
    }

    protected Cookie createCookie(String cookieValue) {
        Cookie c = super.createCookie(cookieValue);
        c.setComment("CAS Cookie");
        return c;
    }

    @Generated
    public void setRememberMeMaxAge(int rememberMeMaxAge) {
        this.rememberMeMaxAge = rememberMeMaxAge;
    }
}

