/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.support;

import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class CasConfigurationJasyptDecryptor {
    public static final String ENCRYPTED_VALUE_PREFIX = "{cipher}";
    private static final Logger LOGGER = LoggerFactory.getLogger(CasConfigurationJasyptDecryptor.class);
    private final StandardPBEStringEncryptor jasyptInstance = new StandardPBEStringEncryptor();

    public CasConfigurationJasyptDecryptor(Environment environment) {
        String iter;
        String pName;
        String psw;
        String alg = CasConfigurationJasyptDecryptor.getJasyptParamFromEnv(environment, JasyptEncryptionParameters.ALGORITHM);
        if (StringUtils.isNotBlank((CharSequence)alg)) {
            LOGGER.debug("Configured jasyptInstance algorithm [{}]", (Object)alg);
            this.jasyptInstance.setAlgorithm(alg);
        }
        if (StringUtils.isNotBlank((CharSequence)(psw = CasConfigurationJasyptDecryptor.getJasyptParamFromEnv(environment, JasyptEncryptionParameters.PASSWORD)))) {
            LOGGER.debug("Configured jasyptInstance password");
            this.jasyptInstance.setPassword(psw);
        }
        if (StringUtils.isNotBlank((CharSequence)(pName = CasConfigurationJasyptDecryptor.getJasyptParamFromEnv(environment, JasyptEncryptionParameters.PROVIDER)))) {
            LOGGER.debug("Configured jasyptInstance provider");
            if (StringUtils.equals((CharSequence)pName, (CharSequence)"BC")) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            this.jasyptInstance.setProviderName(pName);
        }
        if (StringUtils.isNotBlank((CharSequence)(iter = CasConfigurationJasyptDecryptor.getJasyptParamFromEnv(environment, JasyptEncryptionParameters.ITERATIONS))) && NumberUtils.isCreatable((String)iter)) {
            LOGGER.debug("Configured jasyptInstance iterations");
            this.jasyptInstance.setKeyObtentionIterations(Integer.parseInt(iter));
        }
    }

    private static String getJasyptParamFromEnv(Environment environment, JasyptEncryptionParameters param) {
        return environment.getProperty(param.getName(), param.getDefaultValue());
    }

    public String encryptValue(String value) {
        try {
            this.initializeJasyptInstanceIfNecessary();
            return this.jasyptInstance.encrypt(value);
        }
        catch (Exception e) {
            LOGGER.error("Could not encrypt value [{}]", (Throwable)e);
            return null;
        }
    }

    public String decryptValue(String value) {
        try {
            this.initializeJasyptInstanceIfNecessary();
            return this.jasyptInstance.decrypt(value);
        }
        catch (Exception e) {
            LOGGER.error("Could not decrypt value [{}]", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Pair<String, Object> decryptPair(Pair<String, Object> pair) {
        String stringValue = CasConfigurationJasyptDecryptor.getStringPropertyValue(pair.getValue());
        if (!StringUtils.isNotBlank((CharSequence)stringValue) || !stringValue.startsWith(ENCRYPTED_VALUE_PREFIX)) return pair;
        this.initializeJasyptInstanceIfNecessary();
        try {
            String encValue = stringValue.substring(ENCRYPTED_VALUE_PREFIX.length());
            LOGGER.debug("Decrypting property [{}]...", pair.getKey());
            String value = this.decryptValue(encValue);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                LOGGER.debug("Decrypted property [{}] successfully.", pair.getKey());
                return Pair.of((Object)pair.getKey(), (Object)value);
            }
            LOGGER.warn("Decrypted property [{}] has no values.", pair.getKey());
            return null;
        }
        catch (Exception e) {
            try {
                LOGGER.error("Could not decrypt property [{}].", pair.getKey(), (Object)e);
                return pair;
            }
            catch (Exception e2) {
                LOGGER.error("Could not decrypt value [{}]", (Throwable)e2);
                return null;
            }
        }
    }

    private void initializeJasyptInstanceIfNecessary() {
        if (!this.jasyptInstance.isInitialized()) {
            LOGGER.debug("Initializing Jasypt...");
            this.jasyptInstance.initialize();
        }
    }

    public Map<String, Object> decrypt(Map<String, Object> settings) {
        HashMap<String, Object> decrypted = new HashMap<String, Object>();
        settings.forEach((key, value) -> {
            Pair<String, Object> pair = this.decryptPair((Pair<String, Object>)Pair.of((Object)key, (Object)value));
            if (pair != null) {
                decrypted.put((String)pair.getKey(), pair.getValue());
            } else {
                LOGGER.error("CAS will ignore [{}] as it could not process it", key);
            }
        });
        return decrypted;
    }

    private static String getStringPropertyValue(Object propertyValue) {
        return propertyValue instanceof String ? propertyValue.toString() : null;
    }

    public static enum JasyptEncryptionParameters {
        ALGORITHM("cas.standalone.config.security.alg", "PBEWithMD5AndTripleDES"),
        PROVIDER("cas.standalone.config.security.provider", null),
        ITERATIONS("cas.standalone.config.security.iteration", null),
        PASSWORD("cas.standalone.config.security.psw", null);

        private final String name;
        private final String defaultValue;

        private JasyptEncryptionParameters(String name, String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

