/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.support;

import java.time.Duration;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionRandomizedSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.ConnectionPoolingProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.cipher.DefaultTicketCipherExecutor;
import org.apereo.cas.util.cipher.NoOpCipherExecutor;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.apereo.services.persondir.support.NamedStubPersonAttributeDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolExecutorFactoryBean;

public final class Beans {
    private static final Logger LOGGER = LoggerFactory.getLogger(Beans.class);

    protected Beans() {
    }

    public static ThreadPoolExecutorFactoryBean newThreadPoolExecutorFactoryBean(ConnectionPoolingProperties config) {
        ThreadPoolExecutorFactoryBean bean = Beans.newThreadPoolExecutorFactoryBean(config.getMaxSize(), config.getMaxSize());
        bean.setCorePoolSize(config.getMinSize());
        return bean;
    }

    public static ThreadPoolExecutorFactoryBean newThreadPoolExecutorFactoryBean(long keepAlive, long maxSize) {
        ThreadPoolExecutorFactoryBean bean = new ThreadPoolExecutorFactoryBean();
        bean.setMaxPoolSize((int)maxSize);
        bean.setKeepAliveSeconds((int)keepAlive);
        return bean;
    }

    public static IPersonAttributeDao newStubAttributeRepository(PrincipalAttributesProperties p) {
        try {
            NamedStubPersonAttributeDao dao = new NamedStubPersonAttributeDao();
            HashMap pdirMap = new HashMap();
            p.getStub().getAttributes().forEach((key, value) -> {
                String[] vals = org.springframework.util.StringUtils.commaDelimitedListToStringArray((String)value);
                pdirMap.put(key, CollectionUtils.wrap((Object)vals));
            });
            dao.setBackingMap(pdirMap);
            return dao;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Duration newDuration(String length) {
        try {
            if (NumberUtils.isCreatable((String)length)) {
                return Duration.ofSeconds(Long.parseLong(length));
            }
            return Duration.parse(length);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static CipherExecutor newTicketRegistryCipherExecutor(EncryptionRandomizedSigningJwtCryptographyProperties registry, String registryName) {
        return Beans.newTicketRegistryCipherExecutor(registry, false, registryName);
    }

    public static CipherExecutor newTicketRegistryCipherExecutor(EncryptionRandomizedSigningJwtCryptographyProperties registry, boolean forceIfBlankKeys, String registryName) {
        boolean enabled = registry.isEnabled();
        if (!enabled && StringUtils.isNotBlank((CharSequence)registry.getEncryption().getKey()) && StringUtils.isNotBlank((CharSequence)registry.getSigning().getKey())) {
            LOGGER.warn("Ticket registry encryption/signing for [{}] is not enabled explicitly in the configuration, yet signing/encryption keys are defined for ticket operations. CAS will proceed to enable the ticket registry encryption/signing functionality. If you intend to turn off this behavior, consider removing/disabling the signing/encryption keys defined in settings", (Object)registryName);
            enabled = true;
        }
        if (enabled || forceIfBlankKeys) {
            LOGGER.debug("Ticket registry encryption/signing is enabled for [{}]", (Object)registryName);
            return new DefaultTicketCipherExecutor(registry.getEncryption().getKey(), registry.getSigning().getKey(), registry.getAlg(), registry.getSigning().getKeySize(), registry.getEncryption().getKeySize(), registryName);
        }
        LOGGER.info("Ticket registry encryption/signing is turned off. This MAY NOT be safe in a clustered production environment. Consider using other choices to handle encryption, signing and verification of ticket registry tickets, and verify the chosen ticket registry does support this behavior.");
        return NoOpCipherExecutor.getInstance();
    }
}

