/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.model.support.wsfed;

import java.io.Serializable;
import org.apereo.cas.configuration.model.core.authentication.PersonDirectoryPrincipalResolverProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.configuration.support.RequiredProperty;
import org.apereo.cas.configuration.support.RequiresModule;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@RequiresModule(name="cas-server-support-wsfederation-webflow")
public class WsFederationDelegationProperties
implements Serializable {
    private static final long serialVersionUID = 5743971334977239938L;
    @RequiredProperty
    private String identityAttribute = "upn";
    @RequiredProperty
    private String identityProviderIdentifier = "https://adfs.example.org/adfs/services/trust";
    @RequiredProperty
    private String identityProviderUrl = "https://adfs.example.org/adfs/ls/";
    @RequiredProperty
    private String signingCertificateResources = "classpath:adfs-signing.crt";
    @RequiredProperty
    private String relyingPartyIdentifier = "urn:cas:localhost";
    private String tolerance = "PT10S";
    private String attributesType = "WSFED";
    private boolean attributeResolverEnabled = true;
    private boolean autoRedirect = true;
    private String encryptionPrivateKey = "classpath:private.key";
    private String encryptionCertificate = "classpath:certificate.crt";
    private String encryptionPrivateKeyPassword = "NONE";
    @NestedConfigurationProperty
    private PersonDirectoryPrincipalResolverProperties principal = new PersonDirectoryPrincipalResolverProperties();
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PersonDirectoryPrincipalResolverProperties getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(PersonDirectoryPrincipalResolverProperties principal) {
        this.principal = principal;
    }

    public boolean isAttributeResolverEnabled() {
        return this.attributeResolverEnabled;
    }

    public void setAttributeResolverEnabled(boolean attributeResolverEnabled) {
        this.attributeResolverEnabled = attributeResolverEnabled;
    }

    public String getIdentityAttribute() {
        return this.identityAttribute;
    }

    public void setIdentityAttribute(String identityAttribute) {
        this.identityAttribute = identityAttribute;
    }

    public String getIdentityProviderIdentifier() {
        return this.identityProviderIdentifier;
    }

    public void setIdentityProviderIdentifier(String identityProviderIdentifier) {
        this.identityProviderIdentifier = identityProviderIdentifier;
    }

    public String getIdentityProviderUrl() {
        return this.identityProviderUrl;
    }

    public void setIdentityProviderUrl(String identityProviderUrl) {
        this.identityProviderUrl = identityProviderUrl;
    }

    public String getSigningCertificateResources() {
        return this.signingCertificateResources;
    }

    public void setSigningCertificateResources(String signingCertificateResources) {
        this.signingCertificateResources = signingCertificateResources;
    }

    public String getRelyingPartyIdentifier() {
        return this.relyingPartyIdentifier;
    }

    public void setRelyingPartyIdentifier(String relyingPartyIdentifier) {
        this.relyingPartyIdentifier = relyingPartyIdentifier;
    }

    public long getTolerance() {
        return Beans.newDuration(this.tolerance).toMillis();
    }

    public void setTolerance(String tolerance) {
        this.tolerance = tolerance;
    }

    public String getAttributesType() {
        return this.attributesType;
    }

    public void setAttributesType(String attributesType) {
        this.attributesType = attributesType;
    }

    public boolean isAutoRedirect() {
        return this.autoRedirect;
    }

    public void setAutoRedirect(boolean autoRedirect) {
        this.autoRedirect = autoRedirect;
    }

    public String getEncryptionPrivateKey() {
        return this.encryptionPrivateKey;
    }

    public void setEncryptionPrivateKey(String encryptionPrivateKey) {
        this.encryptionPrivateKey = encryptionPrivateKey;
    }

    public String getEncryptionCertificate() {
        return this.encryptionCertificate;
    }

    public void setEncryptionCertificate(String encryptionCertificate) {
        this.encryptionCertificate = encryptionCertificate;
    }

    public String getEncryptionPrivateKeyPassword() {
        return this.encryptionPrivateKeyPassword;
    }

    public void setEncryptionPrivateKeyPassword(String encryptionPrivateKeyPassword) {
        this.encryptionPrivateKeyPassword = encryptionPrivateKeyPassword;
    }
}

