/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.model.support.surrogate;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apereo.cas.configuration.model.support.email.EmailProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.sms.SmsProperties;
import org.apereo.cas.configuration.support.RequiredProperty;
import org.apereo.cas.configuration.support.RequiresModule;
import org.apereo.cas.configuration.support.RestEndpointProperties;
import org.apereo.cas.configuration.support.SpringResourceProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@RequiresModule(name="cas-server-support-surrogate-webflow")
public class SurrogateAuthenticationProperties
implements Serializable {
    private static final long serialVersionUID = -2088813217398883623L;
    private String separator = "+";
    private Simple simple = new Simple();
    private Json json = new Json();
    private Ldap ldap = new Ldap();
    private Jdbc jdbc = new Jdbc();
    private Rest rest = new Rest();
    private Tgt tgt = new Tgt();
    @NestedConfigurationProperty
    private EmailProperties mail = new EmailProperties();
    @NestedConfigurationProperty
    private SmsProperties sms = new SmsProperties();

    public EmailProperties getMail() {
        return this.mail;
    }

    public void setMail(EmailProperties mail) {
        this.mail = mail;
    }

    public SmsProperties getSms() {
        return this.sms;
    }

    public void setSms(SmsProperties sms) {
        this.sms = sms;
    }

    public Rest getRest() {
        return this.rest;
    }

    public void setRest(Rest rest) {
        this.rest = rest;
    }

    public Tgt getTgt() {
        return this.tgt;
    }

    public void setTgt(Tgt tgt) {
        this.tgt = tgt;
    }

    public Jdbc getJdbc() {
        return this.jdbc;
    }

    public void setJdbc(Jdbc jdbc) {
        this.jdbc = jdbc;
    }

    public Simple getSimple() {
        return this.simple;
    }

    public void setSimple(Simple simple) {
        this.simple = simple;
    }

    public Json getJson() {
        return this.json;
    }

    public void setJson(Json json) {
        this.json = json;
    }

    public Ldap getLdap() {
        return this.ldap;
    }

    public void setLdap(Ldap ldap) {
        this.ldap = ldap;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    @RequiresModule(name="cas-server-support-surrogate-authentication-jdbc")
    public static class Jdbc
    extends AbstractJpaProperties {
        private static final long serialVersionUID = 8970195444880123796L;
        @RequiredProperty
        private String surrogateSearchQuery = "SELECT COUNT(*) FROM surrogate WHERE username=?";
        @RequiredProperty
        private String surrogateAccountQuery = "SELECT surrogate_user AS surrogateAccount FROM surrogate WHERE username=?";

        public String getSurrogateSearchQuery() {
            return this.surrogateSearchQuery;
        }

        public void setSurrogateSearchQuery(String surrogateSearchQuery) {
            this.surrogateSearchQuery = surrogateSearchQuery;
        }

        public String getSurrogateAccountQuery() {
            return this.surrogateAccountQuery;
        }

        public void setSurrogateAccountQuery(String surrogateAccountQuery) {
            this.surrogateAccountQuery = surrogateAccountQuery;
        }
    }

    @RequiresModule(name="cas-server-support-surrogate-authentication")
    public static class Tgt
    implements Serializable {
        private static final long serialVersionUID = 2077366413438267330L;
        private long timeToKillInSeconds = 1800L;

        public long getTimeToKillInSeconds() {
            return this.timeToKillInSeconds;
        }

        public void setTimeToKillInSeconds(long timeToKillInSeconds) {
            this.timeToKillInSeconds = timeToKillInSeconds;
        }
    }

    @RequiresModule(name="cas-server-support-surrogate-authentication-ldap")
    public static class Ldap
    extends AbstractLdapProperties {
        private static final long serialVersionUID = -3848837302921751926L;
        @RequiredProperty
        private String baseDn;
        @RequiredProperty
        private String searchFilter;
        private String surrogateSearchFilter;
        @RequiredProperty
        private String memberAttributeName;
        private String memberAttributeValueRegex;

        public String getSurrogateSearchFilter() {
            return this.surrogateSearchFilter;
        }

        public void setSurrogateSearchFilter(String surrogateSearchFilter) {
            this.surrogateSearchFilter = surrogateSearchFilter;
        }

        public String getMemberAttributeName() {
            return this.memberAttributeName;
        }

        public void setMemberAttributeName(String memberAttributeName) {
            this.memberAttributeName = memberAttributeName;
        }

        public String getMemberAttributeValueRegex() {
            return this.memberAttributeValueRegex;
        }

        public void setMemberAttributeValueRegex(String memberAttributeValueRegex) {
            this.memberAttributeValueRegex = memberAttributeValueRegex;
        }

        public String getBaseDn() {
            return this.baseDn;
        }

        public void setBaseDn(String baseDn) {
            this.baseDn = baseDn;
        }

        public String getSearchFilter() {
            return this.searchFilter;
        }

        public void setSearchFilter(String searchFilter) {
            this.searchFilter = searchFilter;
        }
    }

    @RequiresModule(name="cas-server-support-surrogate-authentication-rest")
    public static class Rest
    extends RestEndpointProperties {
        private static final long serialVersionUID = 8152273816132989085L;
    }

    @RequiresModule(name="cas-server-support-surrogate-webflow")
    public static class Json
    extends SpringResourceProperties {
        private static final long serialVersionUID = 3599367681439517829L;
    }

    @RequiresModule(name="cas-server-support-surrogate-webflow")
    public static class Simple
    implements Serializable {
        private static final long serialVersionUID = 16938920863432222L;
        private Map<String, String> surrogates = new LinkedHashMap<String, String>();

        public Map<String, String> getSurrogates() {
            return this.surrogates;
        }

        public void setSurrogates(Map<String, String> surrogates) {
            this.surrogates = surrogates;
        }
    }
}

