/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.model.support.spnego;

import java.io.Serializable;
import org.apereo.cas.configuration.model.core.authentication.PersonDirectoryPrincipalResolverProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.configuration.support.RequiresModule;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@RequiresModule(name="cas-server-support-spnego-webflow")
public class SpnegoProperties
implements Serializable {
    private static final long serialVersionUID = 8084143496524446970L;
    private boolean principalWithDomainName;
    private boolean ntlmAllowed = true;
    private boolean send401OnAuthenticationFailure = true;
    private String hostNameClientActionStrategy = "hostnameSpnegoClientAction";
    private Ldap ldap = new Ldap();
    private String jcifsPassword;
    private String jcifsServicePassword;
    private String jcifsServicePrincipal = "HTTP/cas.example.com@EXAMPLE.COM";
    private String kerberosConf;
    private String kerberosKdc = "172.10.1.10";
    private String kerberosRealm = "EXAMPLE.COM";
    private String loginConf;
    private String timeout = "PT5M";
    private long cachePolicy = 600L;
    private String jcifsNetbiosWins;
    private String jcifsUsername;
    private String jcifsDomainController;
    private String jcifsDomain;
    private String kerberosDebug;
    private boolean useSubjectCredsOnly;
    private String dnsTimeout = "PT2S";
    private String hostNamePatternString = ".+";
    private String ipsToCheckPattern = "127.+";
    private String alternativeRemoteHostAttribute = "alternateRemoteHeader";
    private String spnegoAttributeName = "distinguishedName";
    private boolean ntlm;
    private boolean mixedModeAuthentication;
    private String supportedBrowsers = "MSIE,Trident,Firefox,AppleWebKit";
    @NestedConfigurationProperty
    private PrincipalTransformationProperties principalTransformation = new PrincipalTransformationProperties();
    @NestedConfigurationProperty
    private PersonDirectoryPrincipalResolverProperties principal = new PersonDirectoryPrincipalResolverProperties();
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PrincipalTransformationProperties getPrincipalTransformation() {
        return this.principalTransformation;
    }

    public void setPrincipalTransformation(PrincipalTransformationProperties principalTransformation) {
        this.principalTransformation = principalTransformation;
    }

    public PersonDirectoryPrincipalResolverProperties getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(PersonDirectoryPrincipalResolverProperties principal) {
        this.principal = principal;
    }

    public boolean isSend401OnAuthenticationFailure() {
        return this.send401OnAuthenticationFailure;
    }

    public void setSend401OnAuthenticationFailure(boolean send401OnAuthenticationFailure) {
        this.send401OnAuthenticationFailure = send401OnAuthenticationFailure;
    }

    public String getHostNameClientActionStrategy() {
        return this.hostNameClientActionStrategy;
    }

    public void setHostNameClientActionStrategy(String hostNameClientActionStrategy) {
        this.hostNameClientActionStrategy = hostNameClientActionStrategy;
    }

    public boolean isNtlm() {
        return this.ntlm;
    }

    public void setNtlm(boolean ntlm) {
        this.ntlm = ntlm;
    }

    public boolean isMixedModeAuthentication() {
        return this.mixedModeAuthentication;
    }

    public void setMixedModeAuthentication(boolean mixedModeAuthentication) {
        this.mixedModeAuthentication = mixedModeAuthentication;
    }

    public String getSupportedBrowsers() {
        return this.supportedBrowsers;
    }

    public void setSupportedBrowsers(String supportedBrowsers) {
        this.supportedBrowsers = supportedBrowsers;
    }

    public String getSpnegoAttributeName() {
        return this.spnegoAttributeName;
    }

    public void setSpnegoAttributeName(String spnegoAttributeName) {
        this.spnegoAttributeName = spnegoAttributeName;
    }

    public long getDnsTimeout() {
        return Beans.newDuration(this.dnsTimeout).toMillis();
    }

    public void setDnsTimeout(String dnsTimeout) {
        this.dnsTimeout = dnsTimeout;
    }

    public String getIpsToCheckPattern() {
        return this.ipsToCheckPattern;
    }

    public void setIpsToCheckPattern(String ipsToCheckPattern) {
        this.ipsToCheckPattern = ipsToCheckPattern;
    }

    public String getAlternativeRemoteHostAttribute() {
        return this.alternativeRemoteHostAttribute;
    }

    public void setAlternativeRemoteHostAttribute(String alternativeRemoteHostAttribute) {
        this.alternativeRemoteHostAttribute = alternativeRemoteHostAttribute;
    }

    public String getJcifsPassword() {
        return this.jcifsPassword;
    }

    public String getHostNamePatternString() {
        return this.hostNamePatternString;
    }

    public void setHostNamePatternString(String hostNamePatternString) {
        this.hostNamePatternString = hostNamePatternString;
    }

    public void setJcifsPassword(String jcifsPassword) {
        this.jcifsPassword = jcifsPassword;
    }

    public String getJcifsServicePassword() {
        return this.jcifsServicePassword;
    }

    public void setJcifsServicePassword(String jcifsServicePassword) {
        this.jcifsServicePassword = jcifsServicePassword;
    }

    public String getJcifsServicePrincipal() {
        return this.jcifsServicePrincipal;
    }

    public void setJcifsServicePrincipal(String jcifsServicePrincipal) {
        this.jcifsServicePrincipal = jcifsServicePrincipal;
    }

    public String getKerberosConf() {
        return this.kerberosConf;
    }

    public void setKerberosConf(String kerberosConf) {
        this.kerberosConf = kerberosConf;
    }

    public String getKerberosKdc() {
        return this.kerberosKdc;
    }

    public void setKerberosKdc(String kerberosKdc) {
        this.kerberosKdc = kerberosKdc;
    }

    public String getKerberosRealm() {
        return this.kerberosRealm;
    }

    public void setKerberosRealm(String kerberosRealm) {
        this.kerberosRealm = kerberosRealm;
    }

    public String getLoginConf() {
        return this.loginConf;
    }

    public void setLoginConf(String loginConf) {
        this.loginConf = loginConf;
    }

    public long getTimeout() {
        return Beans.newDuration(this.timeout).toMillis();
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public long getCachePolicy() {
        return this.cachePolicy;
    }

    public void setCachePolicy(long cachePolicy) {
        this.cachePolicy = cachePolicy;
    }

    public String getJcifsNetbiosWins() {
        return this.jcifsNetbiosWins;
    }

    public void setJcifsNetbiosWins(String jcifsNetbiosWins) {
        this.jcifsNetbiosWins = jcifsNetbiosWins;
    }

    public String getJcifsUsername() {
        return this.jcifsUsername;
    }

    public void setJcifsUsername(String jcifsUsername) {
        this.jcifsUsername = jcifsUsername;
    }

    public String getJcifsDomainController() {
        return this.jcifsDomainController;
    }

    public void setJcifsDomainController(String jcifsDomainController) {
        this.jcifsDomainController = jcifsDomainController;
    }

    public String getJcifsDomain() {
        return this.jcifsDomain;
    }

    public void setJcifsDomain(String jcifsDomain) {
        this.jcifsDomain = jcifsDomain;
    }

    public String getKerberosDebug() {
        return this.kerberosDebug;
    }

    public void setKerberosDebug(String kerberosDebug) {
        this.kerberosDebug = kerberosDebug;
    }

    public boolean isUseSubjectCredsOnly() {
        return this.useSubjectCredsOnly;
    }

    public void setUseSubjectCredsOnly(boolean useSubjectCredsOnly) {
        this.useSubjectCredsOnly = useSubjectCredsOnly;
    }

    public boolean isPrincipalWithDomainName() {
        return this.principalWithDomainName;
    }

    public void setPrincipalWithDomainName(boolean principalWithDomainName) {
        this.principalWithDomainName = principalWithDomainName;
    }

    public boolean isNtlmAllowed() {
        return this.ntlmAllowed;
    }

    public void setNtlmAllowed(boolean ntlmAllowed) {
        this.ntlmAllowed = ntlmAllowed;
    }

    public Ldap getLdap() {
        return this.ldap;
    }

    public void setLdap(Ldap ldap) {
        this.ldap = ldap;
    }

    public static class Ldap
    extends AbstractLdapProperties {
        private static final long serialVersionUID = -8835216200501334936L;
        private String baseDn;
        private String searchFilter;

        public String getBaseDn() {
            return this.baseDn;
        }

        public void setBaseDn(String baseDn) {
            this.baseDn = baseDn;
        }

        public String getSearchFilter() {
            return this.searchFilter;
        }

        public void setSearchFilter(String searchFilter) {
            this.searchFilter = searchFilter;
        }
    }
}

