/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.model.support.saml.idp;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apereo.cas.configuration.support.RequiredProperty;
import org.apereo.cas.configuration.support.RequiresModule;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

@RequiresModule(name="cas-server-support-saml-idp")
public class SamlIdPProperties
implements Serializable {
    private static final long serialVersionUID = -5848075783676789852L;
    private boolean attributeQueryProfileEnabled;
    @RequiredProperty
    private String entityId = "https://cas.example.org/idp";
    @RequiredProperty
    private String scope = "example.org";
    private List<String> authenticationContextClassMappings;
    private Response response = new Response();
    private Metadata metadata = new Metadata();
    private Logout logout = new Logout();
    private Algorithms algs = new Algorithms();

    public boolean isAttributeQueryProfileEnabled() {
        return this.attributeQueryProfileEnabled;
    }

    public void setAttributeQueryProfileEnabled(boolean attributeQueryProfileEnabled) {
        this.attributeQueryProfileEnabled = attributeQueryProfileEnabled;
    }

    public List<String> getAuthenticationContextClassMappings() {
        return this.authenticationContextClassMappings;
    }

    public void setAuthenticationContextClassMappings(List<String> authenticationContextClassMappings) {
        this.authenticationContextClassMappings = authenticationContextClassMappings;
    }

    public Algorithms getAlgs() {
        return this.algs;
    }

    public void setAlgs(Algorithms algs) {
        this.algs = algs;
    }

    public Logout getLogout() {
        return this.logout;
    }

    public void setLogout(Logout logout) {
        this.logout = logout;
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public static class Algorithms
    implements Serializable {
        private static final long serialVersionUID = 6547093517788229284L;
        private List overrideDataEncryptionAlgorithms;
        private List overrideKeyEncryptionAlgorithms;
        private List overrideBlackListedEncryptionAlgorithms;
        private List overrideWhiteListedAlgorithms;
        private List overrideSignatureReferenceDigestMethods;
        private List overrideSignatureAlgorithms;
        private List overrideBlackListedSignatureSigningAlgorithms;
        private List overrideWhiteListedSignatureSigningAlgorithms;
        private String overrideSignatureCanonicalizationAlgorithm;

        public String getOverrideSignatureCanonicalizationAlgorithm() {
            return this.overrideSignatureCanonicalizationAlgorithm;
        }

        public void setOverrideSignatureCanonicalizationAlgorithm(String overrideSignatureCanonicalizationAlgorithm) {
            this.overrideSignatureCanonicalizationAlgorithm = overrideSignatureCanonicalizationAlgorithm;
        }

        public List getOverrideDataEncryptionAlgorithms() {
            return this.overrideDataEncryptionAlgorithms;
        }

        public void setOverrideDataEncryptionAlgorithms(List overrideDataEncryptionAlgorithms) {
            this.overrideDataEncryptionAlgorithms = overrideDataEncryptionAlgorithms;
        }

        public List getOverrideKeyEncryptionAlgorithms() {
            return this.overrideKeyEncryptionAlgorithms;
        }

        public void setOverrideKeyEncryptionAlgorithms(List overrideKeyEncryptionAlgorithms) {
            this.overrideKeyEncryptionAlgorithms = overrideKeyEncryptionAlgorithms;
        }

        public List getOverrideBlackListedEncryptionAlgorithms() {
            return this.overrideBlackListedEncryptionAlgorithms;
        }

        public void setOverrideBlackListedEncryptionAlgorithms(List overrideBlackListedEncryptionAlgorithms) {
            this.overrideBlackListedEncryptionAlgorithms = overrideBlackListedEncryptionAlgorithms;
        }

        public List getOverrideWhiteListedAlgorithms() {
            return this.overrideWhiteListedAlgorithms;
        }

        public void setOverrideWhiteListedAlgorithms(List overrideWhiteListedAlgorithms) {
            this.overrideWhiteListedAlgorithms = overrideWhiteListedAlgorithms;
        }

        public List getOverrideSignatureReferenceDigestMethods() {
            return this.overrideSignatureReferenceDigestMethods;
        }

        public void setOverrideSignatureReferenceDigestMethods(List overrideSignatureReferenceDigestMethods) {
            this.overrideSignatureReferenceDigestMethods = overrideSignatureReferenceDigestMethods;
        }

        public List getOverrideSignatureAlgorithms() {
            return this.overrideSignatureAlgorithms;
        }

        public void setOverrideSignatureAlgorithms(List overrideSignatureAlgorithms) {
            this.overrideSignatureAlgorithms = overrideSignatureAlgorithms;
        }

        public List getOverrideBlackListedSignatureSigningAlgorithms() {
            return this.overrideBlackListedSignatureSigningAlgorithms;
        }

        public void setOverrideBlackListedSignatureSigningAlgorithms(List overrideBlackListedSignatureSigningAlgorithms) {
            this.overrideBlackListedSignatureSigningAlgorithms = overrideBlackListedSignatureSigningAlgorithms;
        }

        public List getOverrideWhiteListedSignatureSigningAlgorithms() {
            return this.overrideWhiteListedSignatureSigningAlgorithms;
        }

        public void setOverrideWhiteListedSignatureSigningAlgorithms(List overrideWhiteListedSignatureSigningAlgorithms) {
            this.overrideWhiteListedSignatureSigningAlgorithms = overrideWhiteListedSignatureSigningAlgorithms;
        }
    }

    public static class Logout
    implements Serializable {
        private static final long serialVersionUID = -4608824149569614549L;
        private boolean forceSignedLogoutRequests = true;
        private boolean singleLogoutCallbacksDisabled;

        public boolean isForceSignedLogoutRequests() {
            return this.forceSignedLogoutRequests;
        }

        public void setForceSignedLogoutRequests(boolean forceSignedLogoutRequests) {
            this.forceSignedLogoutRequests = forceSignedLogoutRequests;
        }

        public boolean isSingleLogoutCallbacksDisabled() {
            return this.singleLogoutCallbacksDisabled;
        }

        public void setSingleLogoutCallbacksDisabled(boolean singleLogoutCallbacksDisabled) {
            this.singleLogoutCallbacksDisabled = singleLogoutCallbacksDisabled;
        }
    }

    public static class Response
    implements Serializable {
        private static final long serialVersionUID = 7200477683583467619L;
        private SignatureCredentialTypes credentialType = SignatureCredentialTypes.X509;
        private int skewAllowance = 5;
        private boolean signError;
        private String defaultAuthenticationContextClass = "urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport";
        private String defaultAttributeNameFormat = "uri";
        private boolean useAttributeFriendlyName = true;
        private List<String> attributeNameFormats = new ArrayList<String>();

        public SignatureCredentialTypes getCredentialType() {
            return this.credentialType;
        }

        public void setCredentialType(SignatureCredentialTypes credentialType) {
            this.credentialType = credentialType;
        }

        public String getDefaultAuthenticationContextClass() {
            return this.defaultAuthenticationContextClass;
        }

        public void setDefaultAuthenticationContextClass(String defaultAuthenticationContextClass) {
            this.defaultAuthenticationContextClass = defaultAuthenticationContextClass;
        }

        public String getDefaultAttributeNameFormat() {
            return this.defaultAttributeNameFormat;
        }

        public void setDefaultAttributeNameFormat(String defaultAttributeNameFormat) {
            this.defaultAttributeNameFormat = defaultAttributeNameFormat;
        }

        public List<String> getAttributeNameFormats() {
            return this.attributeNameFormats;
        }

        public void setAttributeNameFormats(List<String> attributeNameFormats) {
            this.attributeNameFormats = attributeNameFormats;
        }

        public boolean isUseAttributeFriendlyName() {
            return this.useAttributeFriendlyName;
        }

        public void setUseAttributeFriendlyName(boolean useAttributeFriendlyName) {
            this.useAttributeFriendlyName = useAttributeFriendlyName;
        }

        public int getSkewAllowance() {
            return this.skewAllowance;
        }

        public void setSkewAllowance(int skewAllowance) {
            this.skewAllowance = skewAllowance;
        }

        public boolean isSignError() {
            return this.signError;
        }

        public void setSignError(boolean signError) {
            this.signError = signError;
        }

        public Map<String, String> configureAttributeNameFormats() {
            if (this.attributeNameFormats.isEmpty()) {
                return new HashMap<String, String>(0);
            }
            HashMap<String, String> nameFormats = new HashMap<String, String>();
            this.attributeNameFormats.forEach(value -> Arrays.stream(value.split(",")).forEach(format -> {
                String[] values = format.split("->");
                if (values.length == 2) {
                    nameFormats.put(values[0], values[1]);
                }
            }));
            return nameFormats;
        }

        public static enum SignatureCredentialTypes {
            BASIC,
            X509;

        }
    }

    public static class Metadata
    implements Serializable {
        private static final long serialVersionUID = -1020542741768471305L;
        private boolean failFast = true;
        private boolean requireValidMetadata = true;
        private long cacheExpirationMinutes = TimeUnit.DAYS.toMinutes(1L);
        @RequiredProperty
        private Resource location = new FileSystemResource("/etc/cas/saml");
        private String privateKeyAlgName = "RSA";
        private String basicAuthnUsername;
        private String basicAuthnPassword;
        private List<String> supportedContentTypes = new ArrayList<String>();

        public boolean isFailFast() {
            return this.failFast;
        }

        public void setFailFast(boolean failFast) {
            this.failFast = failFast;
        }

        public boolean isRequireValidMetadata() {
            return this.requireValidMetadata;
        }

        public void setRequireValidMetadata(boolean requireValidMetadata) {
            this.requireValidMetadata = requireValidMetadata;
        }

        public long getCacheExpirationMinutes() {
            return this.cacheExpirationMinutes;
        }

        public void setCacheExpirationMinutes(long cacheExpirationMinutes) {
            this.cacheExpirationMinutes = cacheExpirationMinutes;
        }

        public Resource getLocation() {
            return this.location;
        }

        public void setLocation(Resource location) {
            this.location = location;
        }

        public Resource getSigningCertFile() throws Exception {
            return new FileSystemResource(new File(this.location.getFile(), "/idp-signing.crt"));
        }

        public Resource getSigningKeyFile() throws Exception {
            return new FileSystemResource(new File(this.location.getFile(), "/idp-signing.key"));
        }

        public String getPrivateKeyAlgName() {
            return this.privateKeyAlgName;
        }

        public void setPrivateKeyAlgName(String privateKeyAlgName) {
            this.privateKeyAlgName = privateKeyAlgName;
        }

        public Resource getEncryptionCertFile() throws Exception {
            return new FileSystemResource(new File(this.location.getFile(), "/idp-encryption.crt"));
        }

        public Resource getEncryptionKeyFile() throws Exception {
            return new FileSystemResource(new File(this.location.getFile(), "/idp-encryption.key"));
        }

        public File getMetadataFile() throws Exception {
            return new File(this.location.getFile(), "idp-metadata.xml");
        }

        public String getBasicAuthnUsername() {
            return this.basicAuthnUsername;
        }

        public void setBasicAuthnUsername(String basicAuthnUsername) {
            this.basicAuthnUsername = basicAuthnUsername;
        }

        public String getBasicAuthnPassword() {
            return this.basicAuthnPassword;
        }

        public void setBasicAuthnPassword(String basicAuthnPassword) {
            this.basicAuthnPassword = basicAuthnPassword;
        }

        public List<String> getSupportedContentTypes() {
            return this.supportedContentTypes;
        }

        public void setSupportedContentTypes(List<String> supportedContentTypes) {
            this.supportedContentTypes = supportedContentTypes;
        }
    }
}

