/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.model.support.oidc;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apereo.cas.configuration.support.RequiredProperty;
import org.apereo.cas.configuration.support.RequiresModule;
import org.apereo.cas.util.CollectionUtils;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

@RequiresModule(name="cas-server-support-oidc")
public class OidcProperties
implements Serializable {
    private static final long serialVersionUID = 813028615694269276L;
    private int jwksCacheInMinutes = 60;
    @RequiredProperty
    private String issuer = "http://localhost:8080/cas/oidc";
    private int skew = 5;
    @RequiredProperty
    private Resource jwksFile = new FileSystemResource("/etc/cas/keystore.jwks");
    private String dynamicClientRegistrationMode;
    private List<String> scopes = CollectionUtils.wrapList((Object[])new String[]{"openid", "profile", "email", "address", "phone", "offline_access"});
    private List<String> claims = CollectionUtils.wrapList((Object[])new String[]{"sub", "name", "preferred_username", "family_name", "given_name", "middle_name", "given_name", "profile", "picture", "nickname", "website", "zoneinfo", "locale", "updated_at", "birthdate", "email", "email_verified", "phone_number", "phone_number_verified", "address"});
    private List<String> subjectTypes = CollectionUtils.wrapList((Object[])new String[]{"public", "pairwise"});
    private Map<String, String> userDefinedScopes = new HashMap<String, String>();
    private Map<String, String> claimsMap = new HashMap<String, String>();

    public Map<String, String> getClaimsMap() {
        return this.claimsMap;
    }

    public void setClaimsMap(Map<String, String> claimsMap) {
        this.claimsMap = claimsMap;
    }

    public Map<String, String> getUserDefinedScopes() {
        return this.userDefinedScopes;
    }

    public void setUserDefinedScopes(Map<String, String> userDefinedScopes) {
        this.userDefinedScopes = userDefinedScopes;
    }

    public int getJwksCacheInMinutes() {
        return this.jwksCacheInMinutes;
    }

    public void setJwksCacheInMinutes(int jwksCacheInMinutes) {
        this.jwksCacheInMinutes = jwksCacheInMinutes;
    }

    public List<String> getSubjectTypes() {
        return this.subjectTypes;
    }

    public void setSubjectTypes(List<String> subjectTypes) {
        this.subjectTypes = subjectTypes;
    }

    public List<String> getClaims() {
        return this.claims;
    }

    public void setClaims(List<String> claims) {
        this.claims = claims;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public String getDynamicClientRegistrationMode() {
        return this.dynamicClientRegistrationMode;
    }

    public void setDynamicClientRegistrationMode(String dynamicClientRegistrationMode) {
        this.dynamicClientRegistrationMode = dynamicClientRegistrationMode;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public int getSkew() {
        return this.skew;
    }

    public void setSkew(int skew) {
        this.skew = skew;
    }

    public Resource getJwksFile() {
        return this.jwksFile;
    }

    public void setJwksFile(Resource jwksFile) {
        this.jwksFile = jwksFile;
    }
}

