/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.model.support.mongo;

import java.io.Serializable;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.configuration.support.RequiredProperty;

public abstract class BaseMongoDbProperties
implements Serializable {
    private static final long serialVersionUID = -2471243083598934186L;
    private MongoConnections conns = new MongoConnections();
    @RequiredProperty
    private String clientUri = "";
    @RequiredProperty
    private int port = 27017;
    @RequiredProperty
    private String userId = "";
    @RequiredProperty
    private String password = "";
    @RequiredProperty
    private String host = "localhost";
    private String timeout = "PT5S";
    private String idleTimeout = "PT30S";
    private String writeConcern = "NORMAL";
    @RequiredProperty
    private String databaseName = "";
    private boolean socketKeepAlive;
    private String authenticationDatabaseName;
    private String replicaSet;
    private boolean sslEnabled;

    public String getClientUri() {
        return this.clientUri;
    }

    public void setClientUri(String clientUri) {
        this.clientUri = clientUri;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public long getTimeout() {
        return Beans.newDuration(this.timeout).toMillis();
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public long getIdleTimeout() {
        return Beans.newDuration(this.idleTimeout).toMillis();
    }

    public void setIdleTimeout(String idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public String getWriteConcern() {
        return this.writeConcern;
    }

    public void setWriteConcern(String writeConcern) {
        this.writeConcern = writeConcern;
    }

    public boolean isSocketKeepAlive() {
        return this.socketKeepAlive;
    }

    public void setSocketKeepAlive(boolean socketKeepAlive) {
        this.socketKeepAlive = socketKeepAlive;
    }

    public MongoConnections getConns() {
        return this.conns;
    }

    public void setConns(MongoConnections conns) {
        this.conns = conns;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getAuthenticationDatabaseName() {
        return this.authenticationDatabaseName;
    }

    public void setAuthenticationDatabaseName(String authenticationDatabaseName) {
        this.authenticationDatabaseName = authenticationDatabaseName;
    }

    public String getReplicaSet() {
        return this.replicaSet;
    }

    public void setReplicaSet(String replicaSet) {
        this.replicaSet = replicaSet;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public static class MongoConnections
    implements Serializable {
        private static final long serialVersionUID = -2398415870062168474L;
        private int lifetime = 60000;
        private int perHost = 10;

        public int getLifetime() {
            return this.lifetime;
        }

        public void setLifetime(int lifetime) {
            this.lifetime = lifetime;
        }

        public int getPerHost() {
            return this.perHost;
        }

        public void setPerHost(int perHost) {
            this.perHost = perHost;
        }
    }
}

