/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.model.support.mfa;

import java.io.Serializable;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.mfa.BaseMultifactorProviderProperties;
import org.apereo.cas.configuration.model.support.mongo.SingleCollectionMongoDbProperties;
import org.apereo.cas.configuration.model.support.quartz.ScheduledJobProperties;
import org.apereo.cas.configuration.support.RequiredProperty;
import org.apereo.cas.configuration.support.RequiresModule;
import org.apereo.cas.configuration.support.SpringResourceProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@RequiresModule(name="cas-server-support-gauth")
public class GAuthMultifactorProperties
extends BaseMultifactorProviderProperties {
    public static final String DEFAULT_IDENTIFIER = "mfa-gauth";
    private static final long serialVersionUID = -7401748853833491119L;
    @RequiredProperty
    private String issuer = "CASIssuer";
    @RequiredProperty
    private String label = "CASLabel";
    private int codeDigits = 6;
    private long timeStepSize = 30L;
    private int windowSize = 3;
    private MongoDb mongo = new MongoDb();
    private Jpa jpa = new Jpa();
    private Json json = new Json();
    private Rest rest = new Rest();
    @NestedConfigurationProperty
    private ScheduledJobProperties cleaner = new ScheduledJobProperties("PT1M", "PT1M");

    public GAuthMultifactorProperties() {
        this.setId(DEFAULT_IDENTIFIER);
    }

    public Rest getRest() {
        return this.rest;
    }

    public void setRest(Rest rest) {
        this.rest = rest;
    }

    public ScheduledJobProperties getCleaner() {
        return this.cleaner;
    }

    public void setCleaner(ScheduledJobProperties cleaner) {
        this.cleaner = cleaner;
    }

    public Json getJson() {
        return this.json;
    }

    public void setJson(Json json) {
        this.json = json;
    }

    public MongoDb getMongo() {
        return this.mongo;
    }

    public void setMongo(MongoDb mongodb) {
        this.mongo = mongodb;
    }

    public Jpa getJpa() {
        return this.jpa;
    }

    public void setJpa(Jpa jpa) {
        this.jpa = jpa;
    }

    public int getCodeDigits() {
        return this.codeDigits;
    }

    public void setCodeDigits(int codeDigits) {
        this.codeDigits = codeDigits;
    }

    public long getTimeStepSize() {
        return this.timeStepSize;
    }

    public void setTimeStepSize(long timeStepSize) {
        this.timeStepSize = timeStepSize;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public static class Jpa
    implements Serializable {
        private static final long serialVersionUID = -2689797889546802618L;
        private Database database = new Database();

        public Database getDatabase() {
            return this.database;
        }

        public void setDatabase(Database database) {
            this.database = database;
        }

        public static class Database
        extends AbstractJpaProperties {
            private static final long serialVersionUID = -7446381055350251885L;

            public Database() {
                super.setUrl("jdbc:hsqldb:mem:cas-gauth");
            }
        }
    }

    public static class MongoDb
    extends SingleCollectionMongoDbProperties {
        private static final long serialVersionUID = -200556119517414696L;
        private String tokenCollection;

        public MongoDb() {
            this.setCollection("MongoDbGoogleAuthenticatorRepository");
            this.setTokenCollection("MongoDbGoogleAuthenticatorTokenRepository");
        }

        public String getTokenCollection() {
            return this.tokenCollection;
        }

        public void setTokenCollection(String tokenCollection) {
            this.tokenCollection = tokenCollection;
        }
    }

    public static class Rest
    implements Serializable {
        private static final long serialVersionUID = 4518622579150572559L;
        private String endpointUrl;

        public String getEndpointUrl() {
            return this.endpointUrl;
        }

        public void setEndpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
        }
    }

    public static class Json
    extends SpringResourceProperties {
        private static final long serialVersionUID = 4303355159388663888L;
    }
}

