/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.model.support.jpa.ticketregistry;

import javax.persistence.LockModeType;
import org.apereo.cas.configuration.model.core.util.EncryptionRandomizedSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.configuration.support.RequiresModule;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@RequiresModule(name="cas-server-support-jpa-ticket-registry")
public class JpaTicketRegistryProperties
extends AbstractJpaProperties {
    public static final String DEFAULT_LOCK_TIMEOUT = "PT1H";
    private static final long serialVersionUID = -8053839523783801072L;
    private LockModeType ticketLockType = LockModeType.NONE;
    private String jpaLockingTimeout = "PT1H";
    @NestedConfigurationProperty
    private EncryptionRandomizedSigningJwtCryptographyProperties crypto = new EncryptionRandomizedSigningJwtCryptographyProperties();

    public JpaTicketRegistryProperties() {
        super.setUrl("jdbc:hsqldb:mem:cas-ticket-registry");
        this.crypto.setEnabled(false);
    }

    public EncryptionRandomizedSigningJwtCryptographyProperties getCrypto() {
        return this.crypto;
    }

    public void setCrypto(EncryptionRandomizedSigningJwtCryptographyProperties crypto) {
        this.crypto = crypto;
    }

    public long getJpaLockingTimeout() {
        return Beans.newDuration(this.jpaLockingTimeout).getSeconds();
    }

    public void setJpaLockingTimeout(String jpaLockingTimeout) {
        this.jpaLockingTimeout = jpaLockingTimeout;
    }

    public LockModeType getTicketLockType() {
        return this.ticketLockType;
    }

    public void setTicketLockType(LockModeType ticketLockType) {
        this.ticketLockType = ticketLockType;
    }
}

