/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.model.support.jpa;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apereo.cas.configuration.model.support.ConnectionPoolingProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.configuration.support.RequiredProperty;

public abstract class AbstractJpaProperties
implements Serializable {
    private static final long serialVersionUID = 761486823496930920L;
    private String dialect = "org.hibernate.dialect.HSQLDialect";
    private String ddlAuto = "create-drop";
    @RequiredProperty
    private String driverClass = "org.hsqldb.jdbcDriver";
    @RequiredProperty
    private String url = "jdbc:hsqldb:mem:cas-hsql-database";
    @RequiredProperty
    private String user = "sa";
    @RequiredProperty
    private String password = "";
    private String defaultCatalog;
    private String defaultSchema;
    private String healthQuery = "";
    private String idleTimeout = "PT10M";
    private String dataSourceName;
    private Map<String, String> properties = new HashMap<String, String>();
    private ConnectionPoolingProperties pool = new ConnectionPoolingProperties();
    private int leakThreshold = 3000;
    private int batchSize = 5;
    private long failFastTimeout = 1L;
    private boolean isolateInternalQueries;
    private boolean autocommit;
    private boolean dataSourceProxy;

    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.defaultCatalog = defaultCatalog;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public String getDdlAuto() {
        return this.ddlAuto;
    }

    public void setDdlAuto(String ddlAuto) {
        this.ddlAuto = ddlAuto;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ConnectionPoolingProperties getPool() {
        return this.pool;
    }

    public void setPool(ConnectionPoolingProperties pool) {
        this.pool = pool;
    }

    public long getIdleTimeout() {
        return Beans.newDuration(this.idleTimeout).toMillis();
    }

    public void setIdleTimeout(String idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public int getLeakThreshold() {
        return this.leakThreshold;
    }

    public void setLeakThreshold(int leakThreshold) {
        this.leakThreshold = leakThreshold;
    }

    public boolean isIsolateInternalQueries() {
        return this.isolateInternalQueries;
    }

    public void setIsolateInternalQueries(boolean isolateInternalQueries) {
        this.isolateInternalQueries = isolateInternalQueries;
    }

    public String getHealthQuery() {
        return this.healthQuery;
    }

    public void setHealthQuery(String healthQuery) {
        this.healthQuery = healthQuery;
    }

    public boolean isAutocommit() {
        return this.autocommit;
    }

    public void setAutocommit(boolean autocommit) {
        this.autocommit = autocommit;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public boolean isDataSourceProxy() {
        return this.dataSourceProxy;
    }

    public void setDataSourceProxy(boolean dataSourceProxy) {
        this.dataSourceProxy = dataSourceProxy;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public long getFailFastTimeout() {
        return this.failFastTimeout;
    }

    public void setFailFastTimeout(long failFastTimeout) {
        this.failFastTimeout = failFastTimeout;
    }
}

