/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.model.support.ignite;

import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import org.apereo.cas.configuration.model.core.util.EncryptionRandomizedSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.configuration.support.RequiredProperty;
import org.apereo.cas.configuration.support.RequiresModule;
import org.apereo.cas.util.CollectionUtils;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@RequiresModule(name="cas-server-support-ignite-ticket-registry")
public class IgniteProperties
implements Serializable {
    private static final long serialVersionUID = -5259465262649559156L;
    @RequiredProperty
    private List<String> igniteAddress = CollectionUtils.wrap((Object)"localhost:47500");
    private TicketsCache ticketsCache = new TicketsCache();
    private String keyStoreType = "JKS";
    private String keyStoreFilePath;
    private String keyStorePassword;
    private String trustStoreType = "JKS";
    private String protocol = "TLS";
    private String keyAlgorithm = "SunX509";
    private String trustStoreFilePath;
    private String trustStorePassword;
    private String ackTimeout = "PT2S";
    private String joinTimeout = "PT1S";
    private String localAddress;
    @RequiredProperty
    private int localPort = -1;
    private String networkTimeout = "PT5S";
    private String socketTimeout = "PT5S";
    private int threadPriority = 10;
    private boolean clientMode;
    private boolean forceServerMode;
    @NestedConfigurationProperty
    private EncryptionRandomizedSigningJwtCryptographyProperties crypto = new EncryptionRandomizedSigningJwtCryptographyProperties();

    public IgniteProperties() {
        this.crypto.setEnabled(false);
    }

    public long getAckTimeout() {
        return Duration.parse(this.ackTimeout).toMillis();
    }

    public void setAckTimeout(String ackTimeout) {
        this.ackTimeout = ackTimeout;
    }

    public long getJoinTimeout() {
        return Beans.newDuration(this.joinTimeout).toMillis();
    }

    public void setJoinTimeout(String joinTimeout) {
        this.joinTimeout = joinTimeout;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public long getNetworkTimeout() {
        return Beans.newDuration(this.networkTimeout).toMillis();
    }

    public void setNetworkTimeout(String networkTimeout) {
        this.networkTimeout = networkTimeout;
    }

    public long getSocketTimeout() {
        return Beans.newDuration(this.socketTimeout).toMillis();
    }

    public void setSocketTimeout(String socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public boolean isForceServerMode() {
        return this.forceServerMode;
    }

    public void setForceServerMode(boolean forceServerMode) {
        this.forceServerMode = forceServerMode;
    }

    public boolean isClientMode() {
        return this.clientMode;
    }

    public void setClientMode(boolean clientMode) {
        this.clientMode = clientMode;
    }

    public EncryptionRandomizedSigningJwtCryptographyProperties getCrypto() {
        return this.crypto;
    }

    public void setCrypto(EncryptionRandomizedSigningJwtCryptographyProperties crypto) {
        this.crypto = crypto;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getKeyStoreFilePath() {
        return this.keyStoreFilePath;
    }

    public void setKeyStoreFilePath(String keyStoreFilePath) {
        this.keyStoreFilePath = keyStoreFilePath;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public void setKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
    }

    public String getTrustStoreFilePath() {
        return this.trustStoreFilePath;
    }

    public void setTrustStoreFilePath(String trustStoreFilePath) {
        this.trustStoreFilePath = trustStoreFilePath;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public List<String> getIgniteAddress() {
        return this.igniteAddress;
    }

    public void setIgniteAddress(List<String> igniteAddress) {
        this.igniteAddress = igniteAddress;
    }

    public TicketsCache getTicketsCache() {
        return this.ticketsCache;
    }

    public void setTicketsCache(TicketsCache ticketsCache) {
        this.ticketsCache = ticketsCache;
    }

    public static class TicketsCache
    implements Serializable {
        private static final long serialVersionUID = 4715167757542984471L;
        private String cacheMode = "REPLICATED";
        private String atomicityMode = "TRANSACTIONAL";
        private String writeSynchronizationMode = "FULL_SYNC";

        public String getCacheMode() {
            return this.cacheMode;
        }

        public void setCacheMode(String cacheMode) {
            this.cacheMode = cacheMode;
        }

        public String getAtomicityMode() {
            return this.atomicityMode;
        }

        public void setAtomicityMode(String atomicityMode) {
            this.atomicityMode = atomicityMode;
        }

        public String getWriteSynchronizationMode() {
            return this.writeSynchronizationMode;
        }

        public void setWriteSynchronizationMode(String writeSynchronizationMode) {
            this.writeSynchronizationMode = writeSynchronizationMode;
        }
    }
}

