/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.model.support.ehcache;

import java.io.Serializable;
import org.apereo.cas.configuration.model.core.util.EncryptionRandomizedSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.configuration.support.RequiredProperty;
import org.apereo.cas.configuration.support.RequiresModule;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@RequiresModule(name="cas-server-support-ehcache-ticket-registry")
public class EhcacheProperties
implements Serializable {
    private static final long serialVersionUID = 7772510035918976450L;
    private boolean synchronousWrites;
    private boolean loaderAsync = true;
    private int maxChunkSize = 5000000;
    private int maximumBatchSize = 100;
    private String replicationInterval = "PT10S";
    private boolean replicatePuts = true;
    private boolean replicateUpdatesViaCopy = true;
    private boolean replicateRemovals = true;
    private boolean replicateUpdates = true;
    private boolean replicatePutsViaCopy = true;
    @RequiredProperty
    private Resource configLocation = new ClassPathResource("ehcache-replicated.xml");
    private boolean shared;
    @RequiredProperty
    private String cacheManagerName = "ticketRegistryCacheManager";
    private int diskExpiryThreadIntervalSeconds;
    private boolean eternal;
    private int maxElementsInMemory = 10000;
    private int maxElementsInCache;
    private int maxElementsOnDisk;
    private String memoryStoreEvictionPolicy = "LRU";
    private String persistence = "NONE";
    @NestedConfigurationProperty
    private EncryptionRandomizedSigningJwtCryptographyProperties crypto = new EncryptionRandomizedSigningJwtCryptographyProperties();

    public EhcacheProperties() {
        this.crypto.setEnabled(false);
    }

    public EncryptionRandomizedSigningJwtCryptographyProperties getCrypto() {
        return this.crypto;
    }

    public void setCrypto(EncryptionRandomizedSigningJwtCryptographyProperties crypto) {
        this.crypto = crypto;
    }

    public boolean isLoaderAsync() {
        return this.loaderAsync;
    }

    public void setLoaderAsync(boolean loaderAsync) {
        this.loaderAsync = loaderAsync;
    }

    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public void setMaxChunkSize(int maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
    }

    public int getMaximumBatchSize() {
        return this.maximumBatchSize;
    }

    public void setMaximumBatchSize(int maximumBatchSize) {
        this.maximumBatchSize = maximumBatchSize;
    }

    public long getReplicationInterval() {
        return Beans.newDuration(this.replicationInterval).toMillis();
    }

    public void setReplicationInterval(String replicationInterval) {
        this.replicationInterval = replicationInterval;
    }

    public boolean isReplicatePuts() {
        return this.replicatePuts;
    }

    public void setReplicatePuts(boolean replicatePuts) {
        this.replicatePuts = replicatePuts;
    }

    public boolean isReplicateUpdatesViaCopy() {
        return this.replicateUpdatesViaCopy;
    }

    public void setReplicateUpdatesViaCopy(boolean replicateUpdatesViaCopy) {
        this.replicateUpdatesViaCopy = replicateUpdatesViaCopy;
    }

    public boolean isReplicateRemovals() {
        return this.replicateRemovals;
    }

    public void setReplicateRemovals(boolean replicateRemovals) {
        this.replicateRemovals = replicateRemovals;
    }

    public boolean isReplicateUpdates() {
        return this.replicateUpdates;
    }

    public void setReplicateUpdates(boolean replicateUpdates) {
        this.replicateUpdates = replicateUpdates;
    }

    public boolean isReplicatePutsViaCopy() {
        return this.replicatePutsViaCopy;
    }

    public void setReplicatePutsViaCopy(boolean replicatePutsViaCopy) {
        this.replicatePutsViaCopy = replicatePutsViaCopy;
    }

    public Resource getConfigLocation() {
        return this.configLocation;
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public String getCacheManagerName() {
        return this.cacheManagerName;
    }

    public void setCacheManagerName(String cacheManagerName) {
        this.cacheManagerName = cacheManagerName;
    }

    public int getDiskExpiryThreadIntervalSeconds() {
        return this.diskExpiryThreadIntervalSeconds;
    }

    public void setDiskExpiryThreadIntervalSeconds(int diskExpiryThreadIntervalSeconds) {
        this.diskExpiryThreadIntervalSeconds = diskExpiryThreadIntervalSeconds;
    }

    public boolean isEternal() {
        return this.eternal;
    }

    public void setEternal(boolean eternal) {
        this.eternal = eternal;
    }

    public int getMaxElementsInMemory() {
        return this.maxElementsInMemory;
    }

    public void setMaxElementsInMemory(int maxElementsInMemory) {
        this.maxElementsInMemory = maxElementsInMemory;
    }

    public int getMaxElementsOnDisk() {
        return this.maxElementsOnDisk;
    }

    public void setMaxElementsOnDisk(int maxElementsOnDisk) {
        this.maxElementsOnDisk = maxElementsOnDisk;
    }

    public String getMemoryStoreEvictionPolicy() {
        return this.memoryStoreEvictionPolicy;
    }

    public void setMemoryStoreEvictionPolicy(String memoryStoreEvictionPolicy) {
        this.memoryStoreEvictionPolicy = memoryStoreEvictionPolicy;
    }

    public int getMaxElementsInCache() {
        return this.maxElementsInCache;
    }

    public void setMaxElementsInCache(int maxElementsInCache) {
        this.maxElementsInCache = maxElementsInCache;
    }

    public boolean isSynchronousWrites() {
        return this.synchronousWrites;
    }

    public void setSynchronousWrites(boolean synchronousWrites) {
        this.synchronousWrites = synchronousWrites;
    }

    public String getPersistence() {
        return this.persistence;
    }

    public void setPersistence(String persistence) {
        this.persistence = persistence;
    }
}

