/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.model.support.cookie;

import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.configuration.support.RequiresModule;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@RequiresModule(name="cas-server-support-cookie", automated=true)
public class TicketGrantingCookieProperties
extends CookieProperties {
    private static final long serialVersionUID = 7392972818105536350L;
    private String rememberMeMaxAge = "P14D";
    @NestedConfigurationProperty
    private EncryptionJwtSigningJwtCryptographyProperties crypto = new EncryptionJwtSigningJwtCryptographyProperties();

    public TicketGrantingCookieProperties() {
        super.setName("TGC");
    }

    public EncryptionJwtSigningJwtCryptographyProperties getCrypto() {
        return this.crypto;
    }

    public void setCrypto(EncryptionJwtSigningJwtCryptographyProperties crypto) {
        this.crypto = crypto;
    }

    public long getRememberMeMaxAge() {
        return Beans.newDuration(this.rememberMeMaxAge).getSeconds();
    }

    public void setRememberMeMaxAge(String rememberMeMaxAge) {
        this.rememberMeMaxAge = rememberMeMaxAge;
    }
}

