/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.model.support.consent;

import java.io.Serializable;
import java.time.temporal.ChronoUnit;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.mongo.SingleCollectionMongoDbProperties;
import org.apereo.cas.configuration.support.RequiresModule;
import org.apereo.cas.configuration.support.SpringResourceProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@RequiresModule(name="cas-server-support-consent-webflow")
public class ConsentProperties
implements Serializable {
    private static final long serialVersionUID = 5201308051524438384L;
    private int reminder = 30;
    private ChronoUnit reminderTimeUnit = ChronoUnit.DAYS;
    private Rest rest = new Rest();
    private Ldap ldap = new Ldap();
    private Jpa jpa = new Jpa();
    private Json json = new Json();
    private Groovy groovy = new Groovy();
    private MongoDb mongo = new MongoDb();
    @NestedConfigurationProperty
    private EncryptionJwtSigningJwtCryptographyProperties crypto = new EncryptionJwtSigningJwtCryptographyProperties();

    public EncryptionJwtSigningJwtCryptographyProperties getCrypto() {
        return this.crypto;
    }

    public void setCrypto(EncryptionJwtSigningJwtCryptographyProperties crypto) {
        this.crypto = crypto;
    }

    public Json getJson() {
        return this.json;
    }

    public Groovy getGroovy() {
        return this.groovy;
    }

    public void setGroovy(Groovy groovy) {
        this.groovy = groovy;
    }

    public void setJson(Json json) {
        this.json = json;
    }

    public Jpa getJpa() {
        return this.jpa;
    }

    public void setJpa(Jpa jpa) {
        this.jpa = jpa;
    }

    public Ldap getLdap() {
        return this.ldap;
    }

    public void setLdap(Ldap ldap) {
        this.ldap = ldap;
    }

    public int getReminder() {
        return this.reminder;
    }

    public void setReminder(int reminder) {
        this.reminder = reminder;
    }

    public ChronoUnit getReminderTimeUnit() {
        return this.reminderTimeUnit;
    }

    public void setReminderTimeUnit(ChronoUnit reminderTimeUnit) {
        this.reminderTimeUnit = reminderTimeUnit;
    }

    public Rest getRest() {
        return this.rest;
    }

    public void setRest(Rest rest) {
        this.rest = rest;
    }

    public MongoDb getMongo() {
        return this.mongo;
    }

    public void setMongo(MongoDb mongo) {
        this.mongo = mongo;
    }

    @RequiresModule(name="cas-server-consent-rest")
    public static class Rest
    implements Serializable {
        private static final long serialVersionUID = -6909617495470495341L;
        private String endpoint;

        public String getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }
    }

    @RequiresModule(name="cas-server-consent-mongo")
    public static class MongoDb
    extends SingleCollectionMongoDbProperties {
        private static final long serialVersionUID = -1918436901491275547L;

        public MongoDb() {
            this.setCollection("MongoDbCasConsentRepository");
        }
    }

    @RequiresModule(name="cas-server-consent-ldap")
    public static class Ldap
    extends AbstractLdapProperties {
        private static final long serialVersionUID = 1L;
        private AbstractLdapProperties.LdapType type;
        private String consentAttributeName = "casConsentDecision";
        private boolean subtreeSearch = true;
        private String baseDn;
        private String userFilter;

        public AbstractLdapProperties.LdapType getType() {
            return this.type;
        }

        public void setType(AbstractLdapProperties.LdapType type) {
            this.type = type;
        }

        public String getConsentAttributeName() {
            return this.consentAttributeName;
        }

        public void setConsentAttributeName(String consentAttributeName) {
            this.consentAttributeName = consentAttributeName;
        }

        public boolean isSubtreeSearch() {
            return this.subtreeSearch;
        }

        public void setSubtreeSearch(boolean subtreeSearch) {
            this.subtreeSearch = subtreeSearch;
        }

        public String getBaseDn() {
            return this.baseDn;
        }

        public void setBaseDn(String baseDn) {
            this.baseDn = baseDn;
        }

        public String getUserFilter() {
            return this.userFilter;
        }

        public void setUserFilter(String userFilter) {
            this.userFilter = userFilter;
        }
    }

    @RequiresModule(name="cas-server-consent-jdbc")
    public static class Jpa
    extends AbstractJpaProperties {
        private static final long serialVersionUID = 1646689616653363554L;
    }

    @RequiresModule(name="cas-server-consent-webflow")
    public static class Groovy
    extends SpringResourceProperties {
        private static final long serialVersionUID = 7079027843747126083L;
    }

    @RequiresModule(name="cas-server-consent-webflow")
    public static class Json
    extends SpringResourceProperties {
        private static final long serialVersionUID = 7079027843747126083L;
    }
}

