/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.model.core.monitor;

import java.io.Serializable;
import org.apereo.cas.configuration.model.support.ConnectionPoolingProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.memcached.BaseMemcachedProperties;
import org.apereo.cas.configuration.model.support.mongo.BaseMongoDbProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.configuration.support.RequiresModule;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@RequiresModule(name="cas-server-core-monitor", automated=true)
public class MonitorProperties
implements Serializable {
    private static final long serialVersionUID = -7047060071480971606L;
    private int freeMemThreshold = 10;
    private Tgt tgt = new Tgt();
    private St st = new St();
    private Warn warn = new Warn();
    private Endpoints endpoints = new Endpoints();
    private Jdbc jdbc = new Jdbc();
    private Ldap ldap = new Ldap();
    private Memcached memcached = new Memcached();
    private MongoDb mongo = new MongoDb();

    public Memcached getMemcached() {
        return this.memcached;
    }

    public void setMemcached(Memcached memcached) {
        this.memcached = memcached;
    }

    public Endpoints getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(Endpoints endpoints) {
        this.endpoints = endpoints;
    }

    public Jdbc getJdbc() {
        return this.jdbc;
    }

    public void setJdbc(Jdbc jdbc) {
        this.jdbc = jdbc;
    }

    public Warn getWarn() {
        return this.warn;
    }

    public void setWarn(Warn warn) {
        this.warn = warn;
    }

    public int getFreeMemThreshold() {
        return this.freeMemThreshold;
    }

    public void setFreeMemThreshold(int freeMemThreshold) {
        this.freeMemThreshold = freeMemThreshold;
    }

    public Tgt getTgt() {
        return this.tgt;
    }

    public void setTgt(Tgt tgt) {
        this.tgt = tgt;
    }

    public St getSt() {
        return this.st;
    }

    public void setSt(St st) {
        this.st = st;
    }

    public Ldap getLdap() {
        return this.ldap;
    }

    public void setLdap(Ldap ldap) {
        this.ldap = ldap;
    }

    public MongoDb getMongo() {
        return this.mongo;
    }

    public void setMongo(MongoDb mongo) {
        this.mongo = mongo;
    }

    @RequiresModule(name="cas-server-support-reports", automated=true)
    public static class Endpoints
    extends BaseEndpoint {
        private Dashboard dashboard = new Dashboard();
        private AuditEvents auditEvents = new AuditEvents();
        private AuthenticationEvents authenticationEvents = new AuthenticationEvents();
        private ConfigurationState configurationState = new ConfigurationState();
        private HealthCheck healthCheck = new HealthCheck();
        private LoggingConfig loggingConfig = new LoggingConfig();
        private Metrics metrics = new Metrics();
        private AttributeResolution attributeResolution = new AttributeResolution();
        private SingleSignOnReport singleSignOnReport = new SingleSignOnReport();
        private Statistics statistics = new Statistics();
        private Discovery discovery = new Discovery();
        private TrustedDevices trustedDevices = new TrustedDevices();
        private Status status = new Status();
        private SingleSignOnStatus singleSignOnStatus = new SingleSignOnStatus();
        private SpringWebflowReport springWebflowReport = new SpringWebflowReport();
        private RegisteredServicesReport registeredServicesReport = new RegisteredServicesReport();
        private ConfigurationMetadata configurationMetadata = new ConfigurationMetadata();

        public Endpoints() {
            this.setSensitive(Boolean.TRUE);
            this.setEnabled(Boolean.FALSE);
        }

        public ConfigurationMetadata getConfigurationMetadata() {
            return this.configurationMetadata;
        }

        public void setConfigurationMetadata(ConfigurationMetadata configurationMetadata) {
            this.configurationMetadata = configurationMetadata;
        }

        public RegisteredServicesReport getRegisteredServicesReport() {
            return this.registeredServicesReport;
        }

        public Discovery getDiscovery() {
            return this.discovery;
        }

        public void setDiscovery(Discovery discovery) {
            this.discovery = discovery;
        }

        public void setRegisteredServicesReport(RegisteredServicesReport registeredServicesReport) {
            this.registeredServicesReport = registeredServicesReport;
        }

        public SpringWebflowReport getSpringWebflowReport() {
            return this.springWebflowReport;
        }

        public void setSpringWebflowReport(SpringWebflowReport springWebflowReport) {
            this.springWebflowReport = springWebflowReport;
        }

        public SingleSignOnStatus getSingleSignOnStatus() {
            return this.singleSignOnStatus;
        }

        public void setSingleSignOnStatus(SingleSignOnStatus singleSignOnStatus) {
            this.singleSignOnStatus = singleSignOnStatus;
        }

        public Status getStatus() {
            return this.status;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public Dashboard getDashboard() {
            return this.dashboard;
        }

        public void setDashboard(Dashboard dashboard) {
            this.dashboard = dashboard;
        }

        public AuditEvents getAuditEvents() {
            return this.auditEvents;
        }

        public void setAuditEvents(AuditEvents auditEvents) {
            this.auditEvents = auditEvents;
        }

        public AuthenticationEvents getAuthenticationEvents() {
            return this.authenticationEvents;
        }

        public void setAuthenticationEvents(AuthenticationEvents authenticationEvents) {
            this.authenticationEvents = authenticationEvents;
        }

        public ConfigurationState getConfigurationState() {
            return this.configurationState;
        }

        public void setConfigurationState(ConfigurationState configurationState) {
            this.configurationState = configurationState;
        }

        public HealthCheck getHealthCheck() {
            return this.healthCheck;
        }

        public void setHealthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
        }

        public LoggingConfig getLoggingConfig() {
            return this.loggingConfig;
        }

        public void setLoggingConfig(LoggingConfig loggingConfig) {
            this.loggingConfig = loggingConfig;
        }

        public Metrics getMetrics() {
            return this.metrics;
        }

        public void setMetrics(Metrics metrics) {
            this.metrics = metrics;
        }

        public AttributeResolution getAttributeResolution() {
            return this.attributeResolution;
        }

        public void setAttributeResolution(AttributeResolution attributeResolution) {
            this.attributeResolution = attributeResolution;
        }

        public SingleSignOnReport getSingleSignOnReport() {
            return this.singleSignOnReport;
        }

        public void setSingleSignOnReport(SingleSignOnReport singleSignOnReport) {
            this.singleSignOnReport = singleSignOnReport;
        }

        public Statistics getStatistics() {
            return this.statistics;
        }

        public void setStatistics(Statistics statistics) {
            this.statistics = statistics;
        }

        public TrustedDevices getTrustedDevices() {
            return this.trustedDevices;
        }

        public void setTrustedDevices(TrustedDevices trustedDevices) {
            this.trustedDevices = trustedDevices;
        }

        @RequiresModule(name="cas-server-core-configuration", automated=true)
        public static class ConfigurationMetadata
        extends BaseEndpoint {
        }

        @RequiresModule(name="cas-server-core-services", automated=true)
        public static class RegisteredServicesReport
        extends BaseEndpoint {
        }

        @RequiresModule(name="cas-server-core-webflow", automated=true)
        public static class SpringWebflowReport
        extends BaseEndpoint {
        }

        @RequiresModule(name="cas-server-core", automated=true)
        public static class SingleSignOnStatus
        extends BaseEndpoint {
        }

        @RequiresModule(name="cas-server-support-discovery", automated=true)
        public static class Discovery
        extends BaseEndpoint {
        }

        @RequiresModule(name="cas-server-core-web", automated=true)
        public static class Status
        extends BaseEndpoint {
        }

        @RequiresModule(name="cas-server-support-mfa-trusted", automated=true)
        public static class TrustedDevices
        extends BaseEndpoint {
        }

        @RequiresModule(name="cas-server-core-web", automated=true)
        public static class Statistics
        extends BaseEndpoint {
        }

        @RequiresModule(name="cas-server-core-web", automated=true)
        public static class SingleSignOnReport
        extends BaseEndpoint {
        }

        @RequiresModule(name="cas-server-support-person-directory", automated=true)
        public static class AttributeResolution
        extends BaseEndpoint {
        }

        @RequiresModule(name="cas-server-support-metrics", automated=true)
        public static class Metrics
        extends BaseEndpoint {
        }

        @RequiresModule(name="cas-server-core-logging", automated=true)
        public static class LoggingConfig
        extends BaseEndpoint {
        }

        @RequiresModule(name="cas-server-core-monitor", automated=true)
        public static class HealthCheck
        extends BaseEndpoint {
        }

        @RequiresModule(name="cas-server-core-configuration", automated=true)
        public static class ConfigurationState
        extends BaseEndpoint {
        }

        @RequiresModule(name="cas-server-support-reports", automated=true)
        public static class AuthenticationEvents
        extends BaseEndpoint {
        }

        @RequiresModule(name="cas-server-support-reports", automated=true)
        public static class AuditEvents
        extends BaseEndpoint {
        }

        @RequiresModule(name="cas-server-support-reports", automated=true)
        public static class Dashboard
        extends BaseEndpoint {
        }
    }

    public static abstract class BaseEndpoint {
        private Boolean enabled;
        private Boolean sensitive;

        public Boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public Boolean isSensitive() {
            return this.sensitive;
        }

        public void setSensitive(Boolean sensitive) {
            this.sensitive = sensitive;
        }
    }

    @RequiresModule(name="cas-server-support-jdbc-monitor")
    public static class Jdbc
    extends AbstractJpaProperties {
        private static final long serialVersionUID = -7139788158851782673L;
        private String validationQuery = "SELECT 1";
        private String maxWait = "PT5S";

        public String getValidationQuery() {
            return this.validationQuery;
        }

        public void setValidationQuery(String validationQuery) {
            this.validationQuery = validationQuery;
        }

        public long getMaxWait() {
            return Beans.newDuration(this.maxWait).toMillis();
        }

        public void setMaxWait(String maxWait) {
            this.maxWait = maxWait;
        }
    }

    @RequiresModule(name="cas-server-support-mongo-monitor")
    public static class MongoDb
    extends BaseMongoDbProperties {
        private static final long serialVersionUID = -1918436901491275547L;
    }

    @RequiresModule(name="cas-server-support-memcached-monitor")
    public static class Memcached
    extends BaseMemcachedProperties {
        private static final long serialVersionUID = -9139788158851782673L;
    }

    @RequiresModule(name="cas-server-core-monitor", automated=true)
    public static class Ldap
    extends AbstractLdapProperties {
        private static final long serialVersionUID = 4722929378440179113L;
        private String maxWait = "PT5S";
        @NestedConfigurationProperty
        private ConnectionPoolingProperties pool = new ConnectionPoolingProperties();

        public ConnectionPoolingProperties getPool() {
            return this.pool;
        }

        public void setPool(ConnectionPoolingProperties pool) {
            this.pool = pool;
        }

        public long getMaxWait() {
            return Beans.newDuration(this.maxWait).toMillis();
        }

        public void setMaxWait(String maxWait) {
            this.maxWait = maxWait;
        }
    }

    @RequiresModule(name="cas-server-core-monitor", automated=true)
    public static class Warn
    implements Serializable {
        private static final long serialVersionUID = 2788617778375787703L;
        private int threshold = 10;
        private long evictionThreshold;

        public Warn() {
        }

        public Warn(int threshold) {
            this.threshold = threshold;
        }

        public int getThreshold() {
            return this.threshold;
        }

        public void setThreshold(int threshold) {
            this.threshold = threshold;
        }

        public long getEvictionThreshold() {
            return this.evictionThreshold;
        }

        public void setEvictionThreshold(long evictionThreshold) {
            this.evictionThreshold = evictionThreshold;
        }
    }

    @RequiresModule(name="cas-server-core-monitor", automated=true)
    public static class Tgt
    implements Serializable {
        private static final long serialVersionUID = -2756454350350278724L;
        @NestedConfigurationProperty
        private Warn warn = new Warn(10000);

        public Warn getWarn() {
            return this.warn;
        }

        public void setWarn(Warn warn) {
            this.warn = warn;
        }
    }

    @RequiresModule(name="cas-server-core-monitor", automated=true)
    public static class St
    implements Serializable {
        private static final long serialVersionUID = -8167395674267219982L;
        @NestedConfigurationProperty
        private Warn warn = new Warn(5000);

        public Warn getWarn() {
            return this.warn;
        }

        public void setWarn(Warn warn) {
            this.warn = warn;
        }
    }
}

