/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.model.core.metrics;

import java.io.Serializable;
import org.apereo.cas.configuration.model.support.influxdb.InfluxDbProperties;
import org.apereo.cas.configuration.model.support.mongo.SingleCollectionMongoDbProperties;
import org.apereo.cas.configuration.model.support.redis.BaseRedisProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.configuration.support.RequiredProperty;
import org.apereo.cas.configuration.support.RequiresModule;

@RequiresModule(name="cas-server-core-authentication", automated=true)
public class MetricsProperties
implements Serializable {
    private static final long serialVersionUID = 345002357523418414L;
    private String refreshInterval = "PT30S";
    private String loggerName = "perfStatsLogger";
    private Redis redis = new Redis();
    private Statsd statsd = new Statsd();
    private MongoDb mongo = new MongoDb();
    private InfluxDb influxDb = new InfluxDb();
    private OpenTsdb openTsdb = new OpenTsdb();

    public MongoDb getMongo() {
        return this.mongo;
    }

    public void setMongo(MongoDb mongo) {
        this.mongo = mongo;
    }

    public InfluxDb getInfluxDb() {
        return this.influxDb;
    }

    public void setInfluxDb(InfluxDb influxDb) {
        this.influxDb = influxDb;
    }

    public Statsd getStatsd() {
        return this.statsd;
    }

    public void setStatsd(Statsd statsd) {
        this.statsd = statsd;
    }

    public OpenTsdb getOpenTsdb() {
        return this.openTsdb;
    }

    public void setOpenTsdb(OpenTsdb openTsdb) {
        this.openTsdb = openTsdb;
    }

    public Redis getRedis() {
        return this.redis;
    }

    public void setRedis(Redis redis) {
        this.redis = redis;
    }

    public long getRefreshInterval() {
        return Beans.newDuration(this.refreshInterval).getSeconds();
    }

    public void setRefreshInterval(String refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    @RequiresModule(name="cas-server-support-metrics")
    public static class Redis
    extends BaseRedisProperties {
        private static final long serialVersionUID = 6419713490013390030L;
        @RequiredProperty
        private String prefix;
        @RequiredProperty
        private String key;

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }
    }

    @RequiresModule(name="cas-server-support-metrics")
    public static class OpenTsdb
    implements Serializable {
        private static final long serialVersionUID = 7419713490013390030L;
        private int connectTimeout = 10000;
        private int readTimeout = 30000;
        @RequiredProperty
        private String url;

        public int getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public int getReadTimeout() {
            return this.readTimeout;
        }

        public void setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    @RequiresModule(name="cas-server-support-metrics")
    public static class Statsd
    implements Serializable {
        private static final long serialVersionUID = 6541713495513399930L;
        @RequiredProperty
        private String host;
        @RequiredProperty
        private int port = 8125;
        private String prefix = "cas";

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }
    }

    @RequiresModule(name="cas-server-support-metrics")
    public static class InfluxDb
    extends InfluxDbProperties {
        private static final long serialVersionUID = 1231713495513399930L;
    }

    @RequiresModule(name="cas-server-support-metrics")
    public static class MongoDb
    extends SingleCollectionMongoDbProperties {
        private static final long serialVersionUID = 8131713495513399930L;
    }
}

